/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.lossfunc;

import org.apache.flink.annotation.Internal;
import org.apache.flink.ml.common.feature.LabeledPointWithWeight;
import org.apache.flink.ml.common.lossfunc.LossFunc;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;

@Internal
public class LeastSquareLoss
implements LossFunc {
    public static final LeastSquareLoss INSTANCE = new LeastSquareLoss();

    private LeastSquareLoss() {
    }

    @Override
    public double computeLoss(LabeledPointWithWeight dataPoint, DenseVector coefficient) {
        double dot = BLAS.dot((Vector)dataPoint.getFeatures(), (Vector)coefficient);
        return dataPoint.getWeight() * 0.5 * Math.pow(dot - dataPoint.getLabel(), 2.0);
    }

    @Override
    public void computeGradient(LabeledPointWithWeight dataPoint, DenseVector coefficient, DenseVector cumGradient) {
        double dot = BLAS.dot((Vector)dataPoint.getFeatures(), (Vector)coefficient);
        BLAS.axpy((double)((dot - dataPoint.getLabel()) * dataPoint.getWeight()), (Vector)dataPoint.getFeatures(), (DenseVector)cumGradient, (int)dataPoint.getFeatures().size());
    }
}

