/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.lossfunc;

import org.apache.flink.annotation.Internal;
import org.apache.flink.ml.common.feature.LabeledPointWithWeight;
import org.apache.flink.ml.common.lossfunc.LossFunc;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;

@Internal
public class BinaryLogisticLoss
implements LossFunc {
    public static final BinaryLogisticLoss INSTANCE = new BinaryLogisticLoss();

    private BinaryLogisticLoss() {
    }

    @Override
    public double computeLoss(LabeledPointWithWeight dataPoint, DenseVector coefficient) {
        double dot = BLAS.dot((Vector)dataPoint.getFeatures(), (Vector)coefficient);
        double labelScaled = 2.0 * dataPoint.getLabel() - 1.0;
        return dataPoint.getWeight() * Math.log(1.0 + Math.exp(-dot * labelScaled));
    }

    @Override
    public void computeGradient(LabeledPointWithWeight dataPoint, DenseVector coefficient, DenseVector cumGradient) {
        double dot = BLAS.dot((Vector)dataPoint.getFeatures(), (Vector)coefficient);
        double labelScaled = 2.0 * dataPoint.getLabel() - 1.0;
        double multiplier = dataPoint.getWeight() * (-labelScaled / (Math.exp(dot * labelScaled) + 1.0));
        BLAS.axpy((double)multiplier, (Vector)dataPoint.getFeatures(), (DenseVector)cumGradient, (int)dataPoint.getFeatures().size());
    }
}

