/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.clustering.kmeans;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.clustering.kmeans.KMeansModelData;
import org.apache.flink.ml.clustering.kmeans.KMeansModelParams;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.common.distance.DistanceMeasure;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.VectorWithNorm;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class OnlineKMeansModel
implements Model<OnlineKMeansModel>,
KMeansModelParams<OnlineKMeansModel> {
    public static final String MODEL_DATA_VERSION_GAUGE_KEY = "modelDataVersion";
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public OnlineKMeansModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public OnlineKMeansModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{Types.INT}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getPredictionCol()}));
        SingleOutputStreamOperator predictionResult = tEnv.toDataStream(inputs[0]).connect(KMeansModelData.getModelDataStream(this.modelDataTable).broadcast()).transform("PredictLabelOperator", (TypeInformation)outputTypeInfo, (TwoInputStreamOperator)new PredictLabelOperator(inputTypeInfo, this.getFeaturesCol(), DistanceMeasure.getInstance((String)this.getDistanceMeasure()), this.getK()));
        return new Table[]{tEnv.fromDataStream((DataStream)predictionResult)};
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static OnlineKMeansModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (OnlineKMeansModel)ReadWriteUtils.loadStageParam((String)path);
    }

    private static class PredictLabelOperator
    extends AbstractStreamOperator<Row>
    implements TwoInputStreamOperator<Row, KMeansModelData, Row> {
        private final RowTypeInfo inputTypeInfo;
        private final String featuresCol;
        private final DistanceMeasure distanceMeasure;
        private final int k;
        private VectorWithNorm[] centroids;
        private ListState<Row> bufferedPointsState;
        private int modelDataVersion = 0;

        public PredictLabelOperator(RowTypeInfo inputTypeInfo, String featuresCol, DistanceMeasure distanceMeasure, int k) {
            this.inputTypeInfo = inputTypeInfo;
            this.featuresCol = featuresCol;
            this.distanceMeasure = distanceMeasure;
            this.k = k;
        }

        public void initializeState(StateInitializationContext context) throws Exception {
            super.initializeState(context);
            this.bufferedPointsState = context.getOperatorStateStore().getListState(new ListStateDescriptor("bufferedPoints", (TypeInformation)this.inputTypeInfo));
        }

        public void open() throws Exception {
            super.open();
            this.getRuntimeContext().getMetricGroup().gauge(OnlineKMeansModel.MODEL_DATA_VERSION_GAUGE_KEY, () -> Integer.toString(this.modelDataVersion));
        }

        public void processElement1(StreamRecord<Row> streamRecord) throws Exception {
            Row dataPoint = (Row)streamRecord.getValue();
            if (this.centroids == null) {
                this.bufferedPointsState.add((Object)dataPoint);
                return;
            }
            DenseVector point = ((Vector)dataPoint.getField(this.featuresCol)).toDense();
            int closestCentroidId = this.distanceMeasure.findClosest(this.centroids, new VectorWithNorm((Vector)point));
            this.output.collect((Object)new StreamRecord((Object)Row.join((Row)dataPoint, (Row[])new Row[]{Row.of((Object[])new Object[]{closestCentroidId})})));
        }

        public void processElement2(StreamRecord<KMeansModelData> streamRecord) throws Exception {
            KMeansModelData modelData = (KMeansModelData)streamRecord.getValue();
            Preconditions.checkArgument((modelData.centroids.length <= this.k ? 1 : 0) != 0);
            this.centroids = new VectorWithNorm[modelData.centroids.length];
            for (int i = 0; i < this.centroids.length; ++i) {
                this.centroids[i] = new VectorWithNorm((Vector)modelData.centroids[i]);
            }
            ++this.modelDataVersion;
            for (Row dataPoint : (Iterable)this.bufferedPointsState.get()) {
                this.processElement1((StreamRecord<Row>)new StreamRecord((Object)dataPoint));
            }
            this.bufferedPointsState.clear();
        }
    }
}

