/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.clustering.agglomerativeclustering;

import org.apache.flink.ml.common.param.HasDistanceMeasure;
import org.apache.flink.ml.common.param.HasFeaturesCol;
import org.apache.flink.ml.common.param.HasPredictionCol;
import org.apache.flink.ml.common.param.HasWindows;
import org.apache.flink.ml.param.BooleanParam;
import org.apache.flink.ml.param.DoubleParam;
import org.apache.flink.ml.param.IntParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.ml.param.StringParam;

public interface AgglomerativeClusteringParams<T>
extends HasDistanceMeasure<T>,
HasFeaturesCol<T>,
HasPredictionCol<T>,
HasWindows<T> {
    public static final Param<Integer> NUM_CLUSTERS = new IntParam("numClusters", "The max number of clusters to create.", Integer.valueOf(2));
    public static final Param<Double> DISTANCE_THRESHOLD = new DoubleParam("distanceThreshold", "Threshold to decide whether two clusters should be merged.", null);
    public static final String LINKAGE_WARD = "ward";
    public static final String LINKAGE_COMPLETE = "complete";
    public static final String LINKAGE_SINGLE = "single";
    public static final String LINKAGE_AVERAGE = "average";
    public static final Param<String> LINKAGE = new StringParam("linkage", "Criterion for computing distance between two clusters.", "ward", ParamValidators.inArray((Object[])new String[]{"ward", "complete", "average", "single"}));
    public static final Param<Boolean> COMPUTE_FULL_TREE = new BooleanParam("computeFullTree", "Whether computes the full tree after convergence.", Boolean.valueOf(false), ParamValidators.notNull());

    default public Integer getNumClusters() {
        return (Integer)this.get(NUM_CLUSTERS);
    }

    default public T setNumClusters(Integer value) {
        return (T)this.set(NUM_CLUSTERS, value);
    }

    default public String getLinkage() {
        return (String)this.get(LINKAGE);
    }

    default public T setLinkage(String value) {
        return (T)this.set(LINKAGE, value);
    }

    default public Double getDistanceThreshold() {
        return (Double)this.get(DISTANCE_THRESHOLD);
    }

    default public T setDistanceThreshold(Double value) {
        return (T)this.set(DISTANCE_THRESHOLD, value);
    }

    default public Boolean getComputeFullTree() {
        return (Boolean)this.get(COMPUTE_FULL_TREE);
    }

    default public T setComputeFullTree(Boolean value) {
        return (T)this.set(COMPUTE_FULL_TREE, value);
    }
}

