/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.naivebayes;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.classification.naivebayes.NaiveBayesModelData;
import org.apache.flink.ml.classification.naivebayes.NaiveBayesModelParams;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class NaiveBayesModel
implements Model<NaiveBayesModel>,
NaiveBayesModelParams<NaiveBayesModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public NaiveBayesModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        String predictionCol = this.getPredictionCol();
        String featuresCol = this.getFeaturesCol();
        String broadcastModelKey = "NaiveBayesModelStream";
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{TypeInformation.of(Double.class)}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{predictionCol}));
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)this.modelDataTable).getTableEnvironment();
        DataStream<NaiveBayesModelData> modelDataStream = NaiveBayesModelData.getModelDataStream(this.modelDataTable);
        DataStream input = tEnv.toDataStream(inputs[0]);
        Function<List, DataStream> function = dataStreams -> {
            DataStream stream = (DataStream)dataStreams.get(0);
            return stream.map((MapFunction)new PredictLabelFunction(featuresCol, "NaiveBayesModelStream"), (TypeInformation)outputTypeInfo);
        };
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(input), Collections.singletonMap("NaiveBayesModelStream", modelDataStream), function);
        Table outputTable = tEnv.fromDataStream(output);
        return new Table[]{outputTable};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
        ReadWriteUtils.saveModelData(NaiveBayesModelData.getModelDataStream(this.modelDataTable), (String)path, (Encoder)new NaiveBayesModelData.ModelDataEncoder());
    }

    public static NaiveBayesModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        NaiveBayesModel model = (NaiveBayesModel)ReadWriteUtils.loadStageParam((String)path);
        Table modelDataTable = ReadWriteUtils.loadModelData((StreamTableEnvironment)tEnv, (String)path, (SimpleStreamFormat)new NaiveBayesModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public NaiveBayesModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    private static double findMaxProbLabel(DenseVector prob, Vector label) {
        double result = 0.0;
        int probSize = prob.size();
        double maxVal = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < probSize; ++i) {
            if (!(maxVal < prob.values[i])) continue;
            maxVal = prob.values[i];
            result = label.get(i);
        }
        Preconditions.checkArgument((maxVal > Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
        return result;
    }

    private static DenseVector calculateProb(NaiveBayesModelData modelData, Vector data) {
        int labelSize = modelData.labels.size();
        DenseVector probs = new DenseVector(new double[labelSize]);
        for (int i = 0; i < labelSize; ++i) {
            Map<Double, Double>[] labelData = modelData.theta[i];
            for (int j = 0; j < data.size(); ++j) {
                int n = i;
                probs.values[n] = probs.values[n] + labelData[j].get(data.get(j));
            }
        }
        BLAS.axpy((double)1.0, (Vector)modelData.piArray, (DenseVector)probs);
        return probs;
    }

    private static class PredictLabelFunction
    extends RichMapFunction<Row, Row> {
        private final String featuresCol;
        private final String broadcastModelKey;
        private NaiveBayesModelData modelData = null;

        public PredictLabelFunction(String featuresCol, String broadcastModelKey) {
            this.featuresCol = featuresCol;
            this.broadcastModelKey = broadcastModelKey;
        }

        public Row map(Row row) {
            if (this.modelData == null) {
                this.modelData = (NaiveBayesModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
            }
            Vector vector = (Vector)row.getField(this.featuresCol);
            double label = NaiveBayesModel.findMaxProbLabel(NaiveBayesModel.calculateProb(this.modelData, vector), (Vector)this.modelData.labels);
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{label})});
        }
    }
}

