/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.logisticregression;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.classification.logisticregression.LogisticRegressionModelData;
import org.apache.flink.ml.classification.logisticregression.LogisticRegressionModelDataUtil;
import org.apache.flink.ml.classification.logisticregression.LogisticRegressionModelServable;
import org.apache.flink.ml.classification.logisticregression.OnlineLogisticRegressionModelParams;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class OnlineLogisticRegressionModel
implements Model<OnlineLogisticRegressionModel>,
OnlineLogisticRegressionModelParams<OnlineLogisticRegressionModel> {
    public static final String MODEL_DATA_VERSION_GAUGE_KEY = "modelDataVersion";
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public OnlineLogisticRegressionModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{Types.DOUBLE, TypeInformation.of(DenseVector.class), Types.LONG}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getPredictionCol(), this.getRawPredictionCol(), this.getModelVersionCol()}));
        SingleOutputStreamOperator predictionResult = tEnv.toDataStream(inputs[0]).connect(LogisticRegressionModelDataUtil.getModelDataStream(this.modelDataTable).broadcast()).transform("PredictLabelOperator", (TypeInformation)outputTypeInfo, (TwoInputStreamOperator)new PredictLabelOperator(inputTypeInfo, this.paramMap));
        return new Table[]{tEnv.fromDataStream((DataStream)predictionResult)};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static OnlineLogisticRegressionModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (OnlineLogisticRegressionModel)ReadWriteUtils.loadStageParam((String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public OnlineLogisticRegressionModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    private static class PredictLabelOperator
    extends AbstractStreamOperator<Row>
    implements TwoInputStreamOperator<Row, LogisticRegressionModelData, Row> {
        private final RowTypeInfo inputTypeInfo;
        private final Map<Param<?>, Object> params;
        private ListState<Row> bufferedPointsState;
        private DenseVector coefficient;
        private long modelDataVersion = 0L;
        private LogisticRegressionModelServable servable;

        public PredictLabelOperator(RowTypeInfo inputTypeInfo, Map<Param<?>, Object> params) {
            this.inputTypeInfo = inputTypeInfo;
            this.params = params;
        }

        public void initializeState(StateInitializationContext context) throws Exception {
            super.initializeState(context);
            this.bufferedPointsState = context.getOperatorStateStore().getListState(new ListStateDescriptor("bufferedPoints", (TypeInformation)this.inputTypeInfo));
        }

        public void open() throws Exception {
            super.open();
            this.getRuntimeContext().getMetricGroup().gauge(OnlineLogisticRegressionModel.MODEL_DATA_VERSION_GAUGE_KEY, () -> Long.toString(this.modelDataVersion));
        }

        public void processElement1(StreamRecord<Row> streamRecord) throws Exception {
            this.processElement(streamRecord);
        }

        public void processElement2(StreamRecord<LogisticRegressionModelData> streamRecord) throws Exception {
            LogisticRegressionModelData modelData = (LogisticRegressionModelData)streamRecord.getValue();
            this.coefficient = modelData.coefficient;
            this.modelDataVersion = modelData.modelVersion;
            for (Row dataPoint : (Iterable)this.bufferedPointsState.get()) {
                this.processElement((StreamRecord<Row>)new StreamRecord((Object)dataPoint));
            }
            this.bufferedPointsState.clear();
        }

        public void processElement(StreamRecord<Row> streamRecord) throws Exception {
            Row dataPoint = (Row)streamRecord.getValue();
            if (this.coefficient == null) {
                this.bufferedPointsState.add((Object)dataPoint);
                return;
            }
            if (this.servable == null) {
                this.servable = new LogisticRegressionModelServable(new LogisticRegressionModelData(this.coefficient, 0L));
                ParamUtils.updateExistingParams((WithParams)this.servable, this.params);
            }
            Vector features = (Vector)dataPoint.getField(this.servable.getFeaturesCol());
            Tuple2 predictionResult = this.servable.transform(features);
            this.output.collect((Object)new StreamRecord((Object)Row.join((Row)dataPoint, (Row[])new Row[]{Row.of((Object[])new Object[]{predictionResult.f0, predictionResult.f1, this.modelDataVersion})})));
        }
    }
}

