/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.logisticregression;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.classification.logisticregression.LogisticRegressionModelData;
import org.apache.flink.ml.classification.logisticregression.LogisticRegressionModelDataUtil;
import org.apache.flink.ml.classification.logisticregression.LogisticRegressionModelParams;
import org.apache.flink.ml.classification.logisticregression.LogisticRegressionModelServable;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class LogisticRegressionModel
implements Model<LogisticRegressionModel>,
LogisticRegressionModelParams<LogisticRegressionModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public LogisticRegressionModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream inputStream = tEnv.toDataStream(inputs[0]);
        String broadcastModelKey = "broadcastModelKey";
        DataStream<LogisticRegressionModelData> modelDataStream = LogisticRegressionModelDataUtil.getModelDataStream(this.modelDataTable);
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{BasicTypeInfo.DOUBLE_TYPE_INFO, TypeInformation.of(DenseVector.class)}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getPredictionCol(), this.getRawPredictionCol()}));
        DataStream predictionResult = BroadcastUtils.withBroadcastStream(Collections.singletonList(inputStream), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.map((MapFunction)new PredictLabelFunction("broadcastModelKey", this.paramMap), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(predictionResult)};
    }

    public LogisticRegressionModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
        ReadWriteUtils.saveModelData(LogisticRegressionModelDataUtil.getModelDataStream(this.modelDataTable), (String)path, (Encoder)new LogisticRegressionModelDataUtil.ModelDataEncoder());
    }

    public static LogisticRegressionModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        LogisticRegressionModel model = (LogisticRegressionModel)ReadWriteUtils.loadStageParam((String)path);
        Table modelDataTable = ReadWriteUtils.loadModelData((StreamTableEnvironment)tEnv, (String)path, (SimpleStreamFormat)new LogisticRegressionModelDataUtil.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    public static LogisticRegressionModelServable loadServable(String path) throws IOException {
        return LogisticRegressionModelServable.load((String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class PredictLabelFunction
    extends RichMapFunction<Row, Row> {
        private final String broadcastModelKey;
        private final Map<Param<?>, Object> params;
        private LogisticRegressionModelServable servable;

        public PredictLabelFunction(String broadcastModelKey, Map<Param<?>, Object> params) {
            this.broadcastModelKey = broadcastModelKey;
            this.params = params;
        }

        public Row map(Row dataPoint) {
            if (this.servable == null) {
                LogisticRegressionModelData modelData = (LogisticRegressionModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                this.servable = new LogisticRegressionModelServable(modelData);
                ParamUtils.updateExistingParams((WithParams)this.servable, this.params);
            }
            Vector features = (Vector)dataPoint.getField(this.servable.getFeaturesCol());
            Tuple2 predictionResult = this.servable.transform(features);
            return Row.join((Row)dataPoint, (Row[])new Row[]{Row.of((Object[])new Object[]{predictionResult.f0, predictionResult.f1})});
        }
    }
}

