/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.linearsvc;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.classification.linearsvc.LinearSVCModelData;
import org.apache.flink.ml.classification.linearsvc.LinearSVCModelParams;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class LinearSVCModel
implements Model<LinearSVCModel>,
LinearSVCModelParams<LinearSVCModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public LinearSVCModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream inputStream = tEnv.toDataStream(inputs[0]);
        String broadcastModelKey = "broadcastModelKey";
        DataStream<LinearSVCModelData> modelDataStream = LinearSVCModelData.getModelDataStream(this.modelDataTable);
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{BasicTypeInfo.DOUBLE_TYPE_INFO, DenseVectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getPredictionCol(), this.getRawPredictionCol()}));
        DataStream predictionResult = BroadcastUtils.withBroadcastStream(Collections.singletonList(inputStream), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.map((MapFunction)new PredictLabelFunction("broadcastModelKey", this.getFeaturesCol(), this.getThreshold()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(predictionResult)};
    }

    public LinearSVCModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
        ReadWriteUtils.saveModelData(LinearSVCModelData.getModelDataStream(this.modelDataTable), (String)path, (Encoder)new LinearSVCModelData.ModelDataEncoder());
    }

    public static LinearSVCModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        LinearSVCModel model = (LinearSVCModel)ReadWriteUtils.loadStageParam((String)path);
        Table modelDataTable = ReadWriteUtils.loadModelData((StreamTableEnvironment)tEnv, (String)path, (SimpleStreamFormat)new LinearSVCModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static Row predictOneDataPoint(DenseVector feature, DenseVector coefficient, double threshold) {
        double dotValue = BLAS.dot((Vector)feature, (Vector)coefficient);
        return Row.of((Object[])new Object[]{dotValue >= threshold ? 1.0 : 0.0, Vectors.dense((double[])new double[]{dotValue, -dotValue})});
    }

    private static class PredictLabelFunction
    extends RichMapFunction<Row, Row> {
        private final String broadcastModelKey;
        private final String featuresCol;
        private final double threshold;
        private DenseVector coefficient;

        public PredictLabelFunction(String broadcastModelKey, String featuresCol, double threshold) {
            this.broadcastModelKey = broadcastModelKey;
            this.featuresCol = featuresCol;
            this.threshold = threshold;
        }

        public Row map(Row dataPoint) {
            if (this.coefficient == null) {
                LinearSVCModelData modelData = (LinearSVCModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                this.coefficient = modelData.coefficient;
            }
            DenseVector features = ((Vector)dataPoint.getField(this.featuresCol)).toDense();
            Row predictionResult = LinearSVCModel.predictOneDataPoint(features, this.coefficient, this.threshold);
            return Row.join((Row)dataPoint, (Row[])new Row[]{predictionResult});
        }
    }
}

