/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.common;

import java.util.Random;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.types.Row;

public abstract class RowGenerator
extends RichParallelSourceFunction<Row> {
    protected Random random;
    private final long numValues;
    private final long initSeed;
    private long numValuesOnThisTask;
    private volatile boolean isRunning = true;

    public RowGenerator(long numValues, long initSeed) {
        this.numValues = numValues;
        this.initSeed = initSeed;
    }

    public final void open(Configuration parameters) throws Exception {
        super.open(parameters);
        int taskIdx = this.getRuntimeContext().getIndexOfThisSubtask();
        int numTasks = this.getRuntimeContext().getNumberOfParallelSubtasks();
        this.random = new Random(Tuple2.of((Object)this.initSeed, (Object)taskIdx).hashCode());
        long div = this.numValues / (long)numTasks;
        long mod = this.numValues % (long)numTasks;
        this.numValuesOnThisTask = mod > (long)taskIdx ? div + 1L : div;
    }

    public final void run(SourceFunction.SourceContext<Row> ctx) throws Exception {
        for (long cnt = 0L; this.isRunning && cnt < this.numValuesOnThisTask; ++cnt) {
            ctx.collect((Object)this.nextRow());
        }
    }

    public final void cancel() {
        this.isRunning = false;
    }

    protected abstract Row nextRow();

    protected abstract RowTypeInfo getRowTypeInfo();
}

