/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.common;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.benchmark.datagenerator.common.InputTableGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.RowGenerator;
import org.apache.flink.ml.benchmark.datagenerator.param.HasVectorDim;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.ml.param.IntParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class LabeledPointWithWeightGenerator
extends InputTableGenerator<LabeledPointWithWeightGenerator>
implements HasVectorDim<LabeledPointWithWeightGenerator> {
    public static final Param<Integer> FEATURE_ARITY = new IntParam("featureArity", "Arity of each feature. If set to positive value, each feature would be an integer in range [0, arity - 1]. If set to zero, each feature would be a continuous double in range [0, 1).", Integer.valueOf(2), ParamValidators.gtEq((double)0.0));
    public static final Param<Integer> LABEL_ARITY = new IntParam("labelArity", "Arity of label. If set to positive value, the label would be an integer in range [0, arity - 1]. If set to zero, the label would be a continuous double in range [0, 1).", Integer.valueOf(2), ParamValidators.gtEq((double)0.0));

    public LabeledPointWithWeightGenerator() {
        ParamUtils.initializeMapWithDefaultValues((Map)this.paramMap, (WithParams)this);
    }

    public int getFeatureArity() {
        return (Integer)this.get(FEATURE_ARITY);
    }

    public LabeledPointWithWeightGenerator setFeatureArity(int value) {
        return (LabeledPointWithWeightGenerator)this.set(FEATURE_ARITY, value);
    }

    public int getLabelArity() {
        return (Integer)this.get(LABEL_ARITY);
    }

    public LabeledPointWithWeightGenerator setLabelArity(int value) {
        return (LabeledPointWithWeightGenerator)this.set(LABEL_ARITY, value);
    }

    @Override
    protected RowGenerator[] getRowGenerators() {
        final String[][] colNames = this.getColNames();
        Preconditions.checkState((colNames.length == 1 ? 1 : 0) != 0);
        Preconditions.checkState((colNames[0].length == 3 ? 1 : 0) != 0);
        final int vectorDim = this.getVectorDim();
        final int featureArity = this.getFeatureArity();
        final int labelArity = this.getLabelArity();
        return new RowGenerator[]{new RowGenerator(this.getNumValues(), this.getSeed()){

            @Override
            protected Row nextRow() {
                double[] features = new double[vectorDim];
                for (int i = 0; i < vectorDim; ++i) {
                    features[i] = this.getValue(featureArity);
                }
                double label = this.getValue(labelArity);
                double weight = this.random.nextDouble();
                return Row.of((Object[])new Object[]{Vectors.dense((double[])features), label, weight});
            }

            @Override
            protected RowTypeInfo getRowTypeInfo() {
                return new RowTypeInfo(new TypeInformation[]{DenseVectorTypeInfo.INSTANCE, Types.DOUBLE, Types.DOUBLE}, colNames[0]);
            }

            private double getValue(int arity) {
                if (arity > 0) {
                    return this.random.nextInt(arity);
                }
                return this.random.nextDouble();
            }
        }};
    }
}

