/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.common;

import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.benchmark.datagenerator.common.InputTableGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.RowGenerator;
import org.apache.flink.ml.param.IntParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class DoubleGenerator
extends InputTableGenerator<DoubleGenerator> {
    public static final Param<Integer> ARITY = new IntParam("arity", "Arity of the generated double values. If set to positive value, each feature would be an integer in range [0, arity - 1]. If set to zero, each feature would be a continuous double in range [0, 1).", Integer.valueOf(0), ParamValidators.gtEq((double)0.0));

    public int getArity() {
        return (Integer)this.get(ARITY);
    }

    public DoubleGenerator setArity(int value) {
        return (DoubleGenerator)this.set(ARITY, value);
    }

    @Override
    protected RowGenerator[] getRowGenerators() {
        final String[][] colNames = this.getColNames();
        Preconditions.checkState((colNames.length == 1 ? 1 : 0) != 0);
        final int numOutputCols = colNames[0].length;
        final int arity = this.getArity();
        return new RowGenerator[]{new RowGenerator(this.getNumValues(), this.getSeed()){

            @Override
            public Row nextRow() {
                Row r = new Row(numOutputCols);
                for (int i = 0; i < numOutputCols; ++i) {
                    if (arity > 0) {
                        r.setField(i, (Object)this.random.nextInt(arity));
                        continue;
                    }
                    r.setField(i, (Object)this.random.nextDouble());
                }
                return r;
            }

            @Override
            protected RowTypeInfo getRowTypeInfo() {
                Object[] outputTypes = new TypeInformation[colNames[0].length];
                Arrays.fill(outputTypes, Types.DOUBLE);
                return new RowTypeInfo((TypeInformation[])outputTypes, colNames[0]);
            }
        }};
    }
}

