/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.common;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.benchmark.datagenerator.common.InputTableGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.RowGenerator;
import org.apache.flink.ml.benchmark.datagenerator.param.HasArraySize;
import org.apache.flink.ml.benchmark.datagenerator.param.HasVectorDim;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class DenseVectorArrayGenerator
extends InputTableGenerator<DenseVectorArrayGenerator>
implements HasArraySize<DenseVectorArrayGenerator>,
HasVectorDim<DenseVectorArrayGenerator> {
    @Override
    protected RowGenerator[] getRowGenerators() {
        final String[][] columnNames = this.getColNames();
        Preconditions.checkState((columnNames.length == 1 ? 1 : 0) != 0);
        Preconditions.checkState((columnNames[0].length == 1 ? 1 : 0) != 0);
        final int arraySize = this.getArraySize();
        final int vectorDim = this.getVectorDim();
        return new RowGenerator[]{new RowGenerator(this.getNumValues(), this.getSeed()){

            @Override
            protected Row nextRow() {
                DenseVector[] result = new DenseVector[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    result[i] = new DenseVector(vectorDim);
                    for (int j = 0; j < vectorDim; ++j) {
                        result[i].values[j] = this.random.nextDouble();
                    }
                }
                Row row = new Row(1);
                row.setField(0, (Object)result);
                return row;
            }

            @Override
            protected RowTypeInfo getRowTypeInfo() {
                return new RowTypeInfo(new TypeInformation[]{TypeInformation.of(DenseVector[].class)}, columnNames[0]);
            }
        }};
    }
}

