/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.clustering;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.ml.benchmark.datagenerator.DataGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.DenseVectorArrayGenerator;
import org.apache.flink.ml.benchmark.datagenerator.param.HasArraySize;
import org.apache.flink.ml.benchmark.datagenerator.param.HasVectorDim;
import org.apache.flink.ml.clustering.kmeans.KMeansModelData;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public class KMeansModelDataGenerator
implements DataGenerator<KMeansModelDataGenerator>,
HasVectorDim<KMeansModelDataGenerator>,
HasArraySize<KMeansModelDataGenerator> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public KMeansModelDataGenerator() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    @Override
    public Table[] getData(StreamTableEnvironment tEnv) {
        DenseVectorArrayGenerator vectorArrayGenerator = new DenseVectorArrayGenerator();
        ReadWriteUtils.updateExistingParams((WithParams)vectorArrayGenerator, this.paramMap);
        vectorArrayGenerator.setNumValues(1L);
        Table vectorArrayTable = vectorArrayGenerator.getData(tEnv)[0];
        SingleOutputStreamOperator modelDataStream = tEnv.toDataStream(vectorArrayTable, DenseVector[].class).map((MapFunction)new GenerateKMeansModelDataFunction());
        return new Table[]{tEnv.fromDataStream((DataStream)modelDataStream)};
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class GenerateKMeansModelDataFunction
    implements MapFunction<DenseVector[], KMeansModelData> {
        private GenerateKMeansModelDataFunction() {
        }

        public KMeansModelData map(DenseVector[] vectors) {
            return new KMeansModelData(vectors, new DenseVector(vectors.length));
        }
    }
}

