/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.slf4j;

import java.util.ConcurrentModificationException;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.AbstractReporter;
import org.apache.flink.metrics.reporter.InstantiateViaFactory;
import org.apache.flink.metrics.reporter.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InstantiateViaFactory(factoryClassName="org.apache.flink.metrics.slf4j.Slf4jReporterFactory")
public class Slf4jReporter
extends AbstractReporter
implements Scheduled {
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jReporter.class);
    private static final String lineSeparator = System.lineSeparator();
    private int previousSize = 16384;

    @VisibleForTesting
    Map<Gauge<?>, String> getGauges() {
        return this.gauges;
    }

    @VisibleForTesting
    Map<Counter, String> getCounters() {
        return this.counters;
    }

    @VisibleForTesting
    Map<Histogram, String> getHistograms() {
        return this.histograms;
    }

    @VisibleForTesting
    Map<Meter, String> getMeters() {
        return this.meters;
    }

    public void open(MetricConfig metricConfig) {
    }

    public void close() {
    }

    public void report() {
        try {
            this.tryReport();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private void tryReport() {
        StringBuilder builder = new StringBuilder((int)((double)this.previousSize * 1.1));
        builder.append(lineSeparator).append("=========================== Starting metrics report ===========================").append(lineSeparator);
        builder.append(lineSeparator).append("-- Counters -------------------------------------------------------------------").append(lineSeparator);
        for (Map.Entry metric : this.counters.entrySet()) {
            builder.append((String)metric.getValue()).append(": ").append(((Counter)metric.getKey()).getCount()).append(lineSeparator);
        }
        builder.append(lineSeparator).append("-- Gauges ---------------------------------------------------------------------").append(lineSeparator);
        for (Map.Entry metric : this.gauges.entrySet()) {
            builder.append((String)metric.getValue()).append(": ").append(((Gauge)metric.getKey()).getValue()).append(lineSeparator);
        }
        builder.append(lineSeparator).append("-- Meters ---------------------------------------------------------------------").append(lineSeparator);
        for (Map.Entry metric : this.meters.entrySet()) {
            builder.append((String)metric.getValue()).append(": ").append(((Meter)metric.getKey()).getRate()).append(lineSeparator);
        }
        builder.append(lineSeparator).append("-- Histograms -----------------------------------------------------------------").append(lineSeparator);
        for (Map.Entry metric : this.histograms.entrySet()) {
            HistogramStatistics stats = ((Histogram)metric.getKey()).getStatistics();
            builder.append((String)metric.getValue()).append(": count=").append(stats.size()).append(", min=").append(stats.getMin()).append(", max=").append(stats.getMax()).append(", mean=").append(stats.getMean()).append(", stddev=").append(stats.getStdDev()).append(", p50=").append(stats.getQuantile(0.5)).append(", p75=").append(stats.getQuantile(0.75)).append(", p95=").append(stats.getQuantile(0.95)).append(", p98=").append(stats.getQuantile(0.98)).append(", p99=").append(stats.getQuantile(0.99)).append(", p999=").append(stats.getQuantile(0.999)).append(lineSeparator);
        }
        builder.append(lineSeparator).append("=========================== Finished metrics report ===========================").append(lineSeparator);
        LOG.info(builder.toString());
        this.previousSize = builder.length();
    }

    public String filterCharacters(String input) {
        return input;
    }
}

