/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.prometheus.AbstractPrometheusReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class PrometheusPushGatewayReporter
extends AbstractPrometheusReporter
implements Scheduled {
    private final PushGateway pushGateway;
    private final String jobName;
    private final Map<String, String> groupingKey;
    private final boolean deleteOnShutdown;
    @VisibleForTesting
    final URL hostUrl;

    PrometheusPushGatewayReporter(URL hostUrl, String jobName, Map<String, String> groupingKey, boolean deleteOnShutdown) {
        this.hostUrl = hostUrl;
        this.pushGateway = new PushGateway(hostUrl);
        this.jobName = (String)Preconditions.checkNotNull((Object)jobName);
        this.groupingKey = (Map)Preconditions.checkNotNull(groupingKey);
        this.deleteOnShutdown = deleteOnShutdown;
    }

    public void report() {
        try {
            this.pushGateway.push(CollectorRegistry.defaultRegistry, this.jobName, this.groupingKey);
        }
        catch (Exception e) {
            this.log.warn("Failed to push metrics to PushGateway with jobName {}, groupingKey {}.", new Object[]{this.jobName, this.groupingKey, e});
        }
    }

    @Override
    public void close() {
        if (this.deleteOnShutdown && this.pushGateway != null) {
            try {
                this.pushGateway.delete(this.jobName, this.groupingKey);
            }
            catch (IOException e) {
                this.log.warn("Failed to delete metrics from PushGateway with jobName {}, groupingKey {}.", new Object[]{this.jobName, this.groupingKey, e});
            }
        }
        super.close();
    }
}

