/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.maprfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRFsFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MapRFsFactory.class);
    private static final String MAPR_HOME_ENV = "MAPR_HOME";
    private static final String DEFAULT_MAPR_HOME = "/opt/mapr/";
    private static final String MAPR_CLUSTER_CONF_FILE = "/conf/mapr-clusters.conf";
    private static final String MAPR_FS_CLASS_NAME = "com.mapr.fs.MapRFileSystem";

    public String getScheme() {
        return "maprfs";
    }

    public FileSystem create(URI fsUri) throws IOException {
        Preconditions.checkNotNull((Object)fsUri, (String)"fsUri");
        MapRFsFactory.checkMaprFsClassInClassPath();
        try {
            org.apache.hadoop.fs.FileSystem fs;
            LOG.info("Trying to load and instantiate MapR File System");
            Configuration conf = new Configuration();
            String authority = fsUri.getAuthority();
            if (authority == null || authority.isEmpty()) {
                fs = MapRFsFactory.instantiateMapRFsClass(new Object[0]);
            } else {
                String[] cldbLocations = MapRFsFactory.getCLDBLocations(authority);
                fs = MapRFsFactory.instantiateMapRFsClass(authority, cldbLocations);
            }
            fs.initialize(fsUri, conf);
            return new HadoopFileSystem(fs);
        }
        catch (LinkageError e) {
            throw new IOException("Could not load MapR file system. Please make sure the Flink runtime classes are part of the classpath or dependencies.", e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Could not instantiate MapR file system.", t);
        }
    }

    private static String[] getCLDBLocations(String authority) throws IOException {
        String maprHome = System.getenv(MAPR_HOME_ENV);
        if (maprHome == null) {
            maprHome = DEFAULT_MAPR_HOME;
        }
        File maprClusterConf = new File(maprHome, MAPR_CLUSTER_CONF_FILE);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Trying to retrieve MapR cluster configuration from %s", maprClusterConf));
        }
        if (!maprClusterConf.exists()) {
            throw new IOException("Could not find CLDB configuration '" + maprClusterConf.getAbsolutePath() + "', assuming MapR home is '" + maprHome + "'.");
        }
        try (BufferedReader br = new BufferedReader(new FileReader(maprClusterConf));){
            String line;
            while ((line = br.readLine()) != null) {
                String clusterName;
                line = line.trim();
                String[] fields = (line = line.replace('\t', ' ')).split(" ");
                if (fields.length < 1 || !(clusterName = fields[0]).equals(authority)) continue;
                ArrayList<String> cldbLocations = new ArrayList<String>();
                for (int i = 1; i < fields.length; ++i) {
                    if (fields[i].isEmpty() || fields[i].contains("=")) continue;
                    cldbLocations.add(fields[i]);
                }
                if (cldbLocations.isEmpty()) {
                    throw new IOException(String.format("%s contains entry for cluster %s but no CLDB locations.", maprClusterConf, authority));
                }
                String[] stringArray = cldbLocations.toArray(new String[cldbLocations.size()]);
                return stringArray;
            }
        }
        throw new IOException(String.format("Unable to find CLDB locations for cluster %s", authority));
    }

    private static void checkMaprFsClassInClassPath() throws IOException {
        try {
            Class.forName(MAPR_FS_CLASS_NAME, false, MapRFsFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot find MapR FS in classpath: com.mapr.fs.MapRFileSystem", e);
        }
    }

    @VisibleForTesting
    static org.apache.hadoop.fs.FileSystem instantiateMapRFsClass(Object ... args) throws IOException {
        Class<org.apache.hadoop.fs.FileSystem> fsClazz;
        try {
            fsClazz = Class.forName(MAPR_FS_CLASS_NAME).asSubclass(org.apache.hadoop.fs.FileSystem.class);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot load MapR FS. Class missing in classpath", e);
        }
        catch (ClassCastException e) {
            throw new IOException("Class 'com.mapr.fs.MapRFileSystem' is not a subclass of org.apache.hadoop.fs.FileSystem");
        }
        Class[] constructorArgs = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
        try {
            Constructor<org.apache.hadoop.fs.FileSystem> ctor = fsClazz.getConstructor(constructorArgs);
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new IOException("Cannot instantiate MapR FS class", e);
        }
    }
}

