/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.entrypoint;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.ArtifactFetchOptions;
import org.apache.flink.client.deployment.application.ApplicationClusterEntryPoint;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.program.DefaultPackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.artifact.ArtifactFetchManager;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.entrypoint.KubernetesEntrypointUtils;
import org.apache.flink.kubernetes.entrypoint.KubernetesResourceManagerFactory;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.DynamicParametersConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.security.contexts.SecurityContext;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

@Internal
public final class KubernetesApplicationClusterEntrypoint
extends ApplicationClusterEntryPoint {
    private KubernetesApplicationClusterEntrypoint(Configuration configuration, PackagedProgram program) {
        super(configuration, program, (ResourceManagerFactory)KubernetesResourceManagerFactory.getInstance());
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)KubernetesApplicationClusterEntrypoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Configuration dynamicParameters = (Configuration)ClusterEntrypointUtils.parseParametersOrExit((String[])args, (ParserResultFactory)new DynamicParametersConfigurationParserFactory(), KubernetesApplicationClusterEntrypoint.class);
        Configuration configuration = KubernetesEntrypointUtils.loadConfiguration(dynamicParameters);
        PackagedProgram program = null;
        try {
            PluginManager pluginManager = PluginUtils.createPluginManagerFromRootFolder((Configuration)configuration);
            LOG.info("Install default filesystem for fetching user artifacts in Kubernetes Application Mode.");
            FileSystem.initialize((Configuration)configuration, (PluginManager)pluginManager);
            SecurityContext securityContext = KubernetesApplicationClusterEntrypoint.installSecurityContext((Configuration)configuration);
            program = (PackagedProgram)securityContext.runSecured(() -> KubernetesApplicationClusterEntrypoint.getPackagedProgram(configuration));
        }
        catch (Exception e) {
            LOG.error("Could not create application program.", (Throwable)e);
            System.exit(1);
        }
        try {
            KubernetesApplicationClusterEntrypoint.configureExecution((Configuration)configuration, program);
        }
        catch (Exception e) {
            LOG.error("Could not apply application configuration.", (Throwable)e);
            System.exit(1);
        }
        KubernetesApplicationClusterEntrypoint kubernetesApplicationClusterEntrypoint = new KubernetesApplicationClusterEntrypoint(configuration, program);
        ClusterEntrypoint.runClusterEntrypoint((ClusterEntrypoint)kubernetesApplicationClusterEntrypoint);
    }

    private static PackagedProgram getPackagedProgram(Configuration configuration) throws FlinkException {
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.fromConfiguration((Configuration)configuration);
        PackagedProgramRetriever programRetriever = KubernetesApplicationClusterEntrypoint.getPackagedProgramRetriever(configuration, applicationConfiguration.getProgramArguments(), applicationConfiguration.getApplicationClassName());
        return programRetriever.getPackagedProgram();
    }

    private static PackagedProgramRetriever getPackagedProgramRetriever(Configuration configuration, String[] programArguments, @Nullable String jobClassName) throws FlinkException {
        File userLibDir = ClusterEntrypointUtils.tryFindUserLibDirectory().orElse(null);
        if (!PackagedProgramUtils.isPython((String)jobClassName).booleanValue() && !PackagedProgramUtils.isPython((String[])programArguments)) {
            ArtifactFetchManager.Result fetchRes = KubernetesApplicationClusterEntrypoint.fetchArtifacts(configuration);
            return DefaultPackagedProgramRetriever.create((File)userLibDir, (File)fetchRes.getJobJar(), (Collection)fetchRes.getArtifacts(), (String)jobClassName, (String[])programArguments, (Configuration)configuration);
        }
        return DefaultPackagedProgramRetriever.create((File)userLibDir, (String)jobClassName, (String[])programArguments, (Configuration)configuration);
    }

    private static ArtifactFetchManager.Result fetchArtifacts(Configuration configuration) {
        try {
            String targetDir = KubernetesApplicationClusterEntrypoint.generateJarDir(configuration);
            ArtifactFetchManager fetchMgr = new ArtifactFetchManager(configuration, targetDir);
            List uris = (List)configuration.get(PipelineOptions.JARS);
            Preconditions.checkArgument((uris.size() == 1 ? 1 : 0) != 0, (Object)"Should only have one jar");
            List additionalUris = configuration.getOptional(ArtifactFetchOptions.ARTIFACT_LIST).orElse(Collections.emptyList());
            return fetchMgr.fetchArtifacts((String)uris.get(0), additionalUris);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String generateJarDir(Configuration configuration) {
        return String.join((CharSequence)File.separator, new File((String)configuration.get(ArtifactFetchOptions.BASE_DIR)).getAbsolutePath(), (CharSequence)configuration.get(KubernetesConfigOptions.NAMESPACE), (CharSequence)configuration.get(KubernetesConfigOptions.CLUSTER_ID));
    }
}

