/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.cache.ItemStore;

public class BasicItemStore<V extends HasMetadata>
implements ItemStore<V> {
    private Function<V, String> keyFunction;
    private ConcurrentHashMap<String, V> store = new ConcurrentHashMap();

    public BasicItemStore(Function<V, String> keyFunction) {
        this.keyFunction = keyFunction;
    }

    @Override
    public String getKey(V obj) {
        return this.keyFunction.apply(obj);
    }

    @Override
    public V put(String key, V obj) {
        return (V)((HasMetadata)this.store.put(key, obj));
    }

    @Override
    public V remove(String key) {
        return (V)((HasMetadata)this.store.remove(key));
    }

    @Override
    public Stream<String> keySet() {
        return this.store.keySet().stream();
    }

    @Override
    public Stream<V> values() {
        return this.store.values().stream();
    }

    @Override
    public V get(String key) {
        return (V)((HasMetadata)this.store.get(key));
    }

    @Override
    public int size() {
        return this.store.size();
    }
}

