/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIGroup;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIGroupBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIGroupList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIService;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIServiceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Binding;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ComponentStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ComponentStatusList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMap;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Endpoints;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EndpointsList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GroupVersionForDiscovery;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LimitRange;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LimitRangeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Namespace;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamespaceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Node;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolume;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PersistentVolumeList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationController;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceQuota;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceQuotaList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Secret;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecretList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceAccount;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceAccountList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.StatefulSet;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authentication.TokenReview;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.batch.v1.Job;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.coordination.v1.LeaseList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClass;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClassList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.AdmissionRegistrationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ApiVisitor;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Client;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.RequestConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1AdmissionRegistrationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1Alpha1AdmissionRegistrationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1Alpha1NetworkAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1Alpha2DynamicResourceAllocationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1ApiextensionAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1AuthenticationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1AuthorizationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1AutoscalingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1NetworkAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1beta1AdmissionRegistrationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1beta1ApiextensionAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1beta1AuthorizationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V1beta1NetworkAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V2AutoscalingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V2beta1AutoscalingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.V2beta2AutoscalingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.VersionInfo;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.WithRequestCallable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ApiextensionsAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AuthenticationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AuthorizationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.BatchAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.CertificatesAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.DiscoveryAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.DynamicResourceAllocationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.EventingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.FlowControlAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.FunctionCallable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.InOutCreateable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MetricAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MixedOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NamespaceableResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NetworkAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PodResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PolicyAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RbacAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.SchedulingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ServiceResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.StorageAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1APIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1Alpha1AuthenticationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1Alpha1CertificatesAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1BatchAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1Beta1AuthenticationAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1CertificatesAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1DiscoveryAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1EventingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1PolicyAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1SchedulingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta1BatchAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta1CertificatesAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta1DiscoveryAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta1EventingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta1FlowControlAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta1PolicyAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta1SchedulingAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta2FlowControlAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.V1beta3FlowControlAPIGroupDSL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.DeploymentOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.batch.v1.JobOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.certificates.v1beta1.CertificateSigningRequestOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.ReplicationControllerOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.ServiceAccountOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.ServiceOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.ReplicaSetOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectorBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunOperations;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.Adapters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.AdmissionRegistrationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.ApiextensionsAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.AppsAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.AuthenticationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.AuthorizationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.AutoscalingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.BaseClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.BatchAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.CertificatesAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.DiscoveryAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.DynamicResourceAllocationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.EventingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.ExtensionsAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.FlowControlAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.Handlers;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.MetricAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.NamespaceableResourceAdapter;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.NetworkAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.PolicyAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.RbacAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.ResourceHandler;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.SchedulingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.StorageAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1APIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1AdmissionRegistrationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1Alpha1AdmissionRegistrationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1Alpha1AuthenticationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1Alpha1CertificatesAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1Alpha1NetworkAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1Alpha2DynamicResourceAllocationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1ApiextensionsAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1AuthenticationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1AuthorizationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1AutoscalingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1BatchAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1Beta1AuthenticationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1CertificatesAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1DiscoveryAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1EventingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1NetworkAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1PolicyAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1SchedulingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1StorageAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1AdmissionRegistrationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1ApiextensionsAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1AuthorizationAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1BatchAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1CertificatesAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1DiscoveryAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1EventingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1FlowControlAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1NetworkAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1PolicyAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1SchedulingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta1StorageAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta2FlowControlAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V1beta3FlowControlAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V2AutoscalingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V2beta1AutoscalingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.V2beta2AutoscalingAPIGroupClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl.SharedInformerFactoryImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientImpl
extends BaseClient
implements NamespacedKubernetesClient {
    public static final Logger logger = LoggerFactory.getLogger(KubernetesClientImpl.class);
    public static final String KUBERNETES_VERSION_ENDPOINT = "version";

    public KubernetesClientImpl(HttpClient httpClient, Config config) {
        this(httpClient, config, () -> Runnable::run, new KubernetesSerialization());
    }

    public KubernetesClientImpl(HttpClient httpClient, Config config, KubernetesClientBuilder.ExecutorSupplier executorSupplier, KubernetesSerialization kubernetesSerialization) {
        super(httpClient, config, executorSupplier, kubernetesSerialization);
        this.registerDefaultAdapters();
        this.registerDefaultHandlers();
    }

    protected KubernetesClientImpl(BaseClient client) {
        super(client);
    }

    protected void registerDefaultAdapters() {
        Adapters adapters = this.getAdapters();
        adapters.registerClient(AppsAPIGroupDSL.class, new AppsAPIGroupClient());
        adapters.registerClient(AdmissionRegistrationAPIGroupDSL.class, new AdmissionRegistrationAPIGroupClient());
        adapters.registerClient(V1AdmissionRegistrationAPIGroupDSL.class, new V1AdmissionRegistrationAPIGroupClient());
        adapters.registerClient(V1beta1AdmissionRegistrationAPIGroupDSL.class, new V1beta1AdmissionRegistrationAPIGroupClient());
        adapters.registerClient(V1Alpha1AdmissionRegistrationAPIGroupDSL.class, new V1Alpha1AdmissionRegistrationAPIGroupClient());
        adapters.registerClient(AutoscalingAPIGroupDSL.class, new AutoscalingAPIGroupClient());
        adapters.registerClient(ApiextensionsAPIGroupDSL.class, new ApiextensionsAPIGroupClient());
        adapters.registerClient(AuthorizationAPIGroupDSL.class, new AuthorizationAPIGroupClient());
        adapters.registerClient(AuthenticationAPIGroupDSL.class, new AuthenticationAPIGroupClient());
        adapters.registerClient(V1AutoscalingAPIGroupDSL.class, new V1AutoscalingAPIGroupClient());
        adapters.registerClient(V2AutoscalingAPIGroupDSL.class, new V2AutoscalingAPIGroupClient());
        adapters.registerClient(V2beta1AutoscalingAPIGroupDSL.class, new V2beta1AutoscalingAPIGroupClient());
        adapters.registerClient(V2beta2AutoscalingAPIGroupDSL.class, new V2beta2AutoscalingAPIGroupClient());
        adapters.registerClient(BatchAPIGroupDSL.class, new BatchAPIGroupClient());
        adapters.registerClient(V1BatchAPIGroupDSL.class, new V1BatchAPIGroupClient());
        adapters.registerClient(V1beta1BatchAPIGroupDSL.class, new V1beta1BatchAPIGroupClient());
        adapters.registerClient(ExtensionsAPIGroupDSL.class, new ExtensionsAPIGroupClient());
        adapters.registerClient(EventingAPIGroupDSL.class, new EventingAPIGroupClient());
        adapters.registerClient(V1EventingAPIGroupDSL.class, new V1EventingAPIGroupClient());
        adapters.registerClient(V1beta1EventingAPIGroupDSL.class, new V1beta1EventingAPIGroupClient());
        adapters.registerClient(FlowControlAPIGroupDSL.class, new FlowControlAPIGroupClient());
        adapters.registerClient(V1beta1FlowControlAPIGroupDSL.class, new V1beta1FlowControlAPIGroupClient());
        adapters.registerClient(V1beta2FlowControlAPIGroupDSL.class, new V1beta2FlowControlAPIGroupClient());
        adapters.registerClient(V1beta3FlowControlAPIGroupDSL.class, new V1beta3FlowControlAPIGroupClient());
        adapters.registerClient(MetricAPIGroupDSL.class, new MetricAPIGroupClient());
        adapters.registerClient(NetworkAPIGroupDSL.class, new NetworkAPIGroupClient());
        adapters.registerClient(PolicyAPIGroupDSL.class, new PolicyAPIGroupClient());
        adapters.registerClient(V1PolicyAPIGroupDSL.class, new V1PolicyAPIGroupClient());
        adapters.registerClient(V1beta1PolicyAPIGroupDSL.class, new V1beta1PolicyAPIGroupClient());
        adapters.registerClient(RbacAPIGroupDSL.class, new RbacAPIGroupClient());
        adapters.registerClient(SchedulingAPIGroupDSL.class, new SchedulingAPIGroupClient());
        adapters.registerClient(V1SchedulingAPIGroupDSL.class, new V1SchedulingAPIGroupClient());
        adapters.registerClient(V1beta1SchedulingAPIGroupDSL.class, new V1beta1SchedulingAPIGroupClient());
        adapters.registerClient(StorageAPIGroupDSL.class, new StorageAPIGroupClient());
        adapters.registerClient(V1StorageAPIGroupClient.class, new V1StorageAPIGroupClient());
        adapters.registerClient(V1beta1StorageAPIGroupClient.class, new V1beta1StorageAPIGroupClient());
        adapters.registerClient(V1APIGroupDSL.class, new V1APIGroupClient());
        adapters.registerClient(V1ApiextensionAPIGroupDSL.class, new V1ApiextensionsAPIGroupClient());
        adapters.registerClient(V1beta1ApiextensionAPIGroupDSL.class, new V1beta1ApiextensionsAPIGroupClient());
        adapters.registerClient(V1AuthorizationAPIGroupDSL.class, new V1AuthorizationAPIGroupClient());
        adapters.registerClient(V1beta1AuthorizationAPIGroupDSL.class, new V1beta1AuthorizationAPIGroupClient());
        adapters.registerClient(V1AuthenticationAPIGroupDSL.class, new V1AuthenticationAPIGroupClient());
        adapters.registerClient(V1Alpha1AuthenticationAPIGroupDSL.class, new V1Alpha1AuthenticationAPIGroupClient());
        adapters.registerClient(V1Beta1AuthenticationAPIGroupDSL.class, new V1Beta1AuthenticationAPIGroupClient());
        adapters.registerClient(V1NetworkAPIGroupDSL.class, new V1NetworkAPIGroupClient());
        adapters.registerClient(V1beta1NetworkAPIGroupDSL.class, new V1beta1NetworkAPIGroupClient());
        adapters.registerClient(V1Alpha1NetworkAPIGroupDSL.class, new V1Alpha1NetworkAPIGroupClient());
        adapters.registerClient(DiscoveryAPIGroupDSL.class, new DiscoveryAPIGroupClient());
        adapters.registerClient(V1beta1DiscoveryAPIGroupDSL.class, new V1beta1DiscoveryAPIGroupClient());
        adapters.registerClient(V1DiscoveryAPIGroupDSL.class, new V1DiscoveryAPIGroupClient());
        adapters.registerClient(DynamicResourceAllocationAPIGroupDSL.class, new DynamicResourceAllocationAPIGroupClient());
        adapters.registerClient(V1Alpha2DynamicResourceAllocationAPIGroupDSL.class, new V1Alpha2DynamicResourceAllocationAPIGroupClient());
        adapters.registerClient(CertificatesAPIGroupDSL.class, new CertificatesAPIGroupClient());
        adapters.registerClient(V1CertificatesAPIGroupDSL.class, new V1CertificatesAPIGroupClient());
        adapters.registerClient(V1beta1CertificatesAPIGroupDSL.class, new V1beta1CertificatesAPIGroupClient());
        adapters.registerClient(V1Alpha1CertificatesAPIGroupDSL.class, new V1Alpha1CertificatesAPIGroupClient());
    }

    protected void registerDefaultHandlers() {
        Handlers handlers = this.getHandlers();
        handlers.register(Pod.class, PodOperationsImpl::new);
        handlers.register(ServiceAccount.class, ServiceAccountOperationsImpl::new);
        handlers.register(Job.class, JobOperationsImpl::new);
        handlers.register(Service.class, ServiceOperationsImpl::new);
        handlers.register(Deployment.class, DeploymentOperationsImpl::new);
        handlers.register(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.Deployment.class, org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.DeploymentOperationsImpl::new);
        handlers.register(ReplicaSet.class, org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.ReplicaSetOperationsImpl::new);
        handlers.register(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.ReplicaSet.class, ReplicaSetOperationsImpl::new);
        handlers.register(ReplicationController.class, ReplicationControllerOperationsImpl::new);
        handlers.register(StatefulSet.class, StatefulSetOperationsImpl::new);
        handlers.register(CertificateSigningRequest.class, org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.certificates.v1.CertificateSigningRequestOperationsImpl::new);
        handlers.register(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest.class, CertificateSigningRequestOperationsImpl::new);
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        return this.newClient(this.createInNamespaceContext(name, false), NamespacedKubernetesClient.class);
    }

    protected OperationContext createInNamespaceContext(String name, boolean any) {
        if (!any && name == null) {
            throw new KubernetesClientException("namespace cannot be null");
        }
        return HasMetadataOperationsImpl.defaultContext(this).withNamespace(name);
    }

    @Override
    public LeaderElectorBuilder leaderElector() {
        return new LeaderElectorBuilder(this, this.getExecutor());
    }

    @Override
    public FunctionCallable<? extends NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<KubernetesClientImpl>(this, requestConfig);
    }

    @Override
    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return this.resources(ComponentStatus.class, ComponentStatusList.class);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.resourceListFor(this.kubernetesSerialization.unmarshal(is));
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return this.resourceListFor(item);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl resourceListFor(Object item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, item);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<? extends HasMetadata> items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.resourceListFor(this.kubernetesSerialization.unmarshal(s));
    }

    @Override
    public <T extends HasMetadata> NamespaceableResource<T> resource(T item) {
        ResourceHandler resourceHandler = this.getHandlers().get(item, this);
        HasMetadataOperation op = resourceHandler.operation(this, null);
        return new NamespaceableResourceAdapter<T>(item, op);
    }

    private NamespaceableResource<HasMetadata> resource(Object resource) {
        if (resource instanceof HasMetadata) {
            return this.resource((HasMetadata)resource);
        }
        throw new KubernetesClientException("Unable to create a valid resource from the provided object (" + resource.getClass().getName() + ")");
    }

    @Override
    public NamespaceableResource<HasMetadata> resource(String s) {
        return this.resource(this.kubernetesSerialization.unmarshal(s));
    }

    @Override
    public NamespaceableResource<HasMetadata> resource(InputStream is) {
        return this.resource(this.kubernetesSerialization.unmarshal(is));
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return this.resources(Binding.class);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return this.resources(Endpoints.class, EndpointsList.class);
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return this.resources(Namespace.class, NamespaceList.class);
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return this.resources(Node.class, NodeList.class);
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return this.resources(PersistentVolume.class, PersistentVolumeList.class);
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.resources(PersistentVolumeClaim.class, PersistentVolumeClaimList.class);
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource> pods() {
        return new PodOperationsImpl(this);
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this);
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return this.resources(ResourceQuota.class, ResourceQuotaList.class);
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return this.resources(Secret.class, SecretList.class);
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return new ServiceOperationsImpl(this);
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, ServiceAccountResource> serviceAccounts() {
        return new ServiceAccountOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return this.resources(APIService.class, APIServiceList.class);
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return this.resources(ConfigMap.class, ConfigMapList.class);
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return this.resources(LimitRange.class, LimitRangeList.class);
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.adapt(ApiextensionsAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest, CertificateSigningRequestList, Resource<org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest>> certificateSigningRequests() {
        return this.resources(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest.class, CertificateSigningRequestList.class);
    }

    @Override
    public CertificatesAPIGroupDSL certificates() {
        return this.adapt(CertificatesAPIGroupClient.class);
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.adapt(AuthorizationAPIGroupClient.class);
    }

    @Override
    public AuthenticationAPIGroupDSL authentication() {
        return this.adapt(AuthenticationAPIGroupClient.class);
    }

    @Override
    public InOutCreateable<TokenReview, TokenReview> tokenReviews() {
        return this.getHandlers().getNonListingOperation(TokenReview.class, this);
    }

    @Override
    public MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> genericKubernetesResources(String apiVersion, String kind) {
        ResourceDefinitionContext context = this.getHandlers().getResourceDefinitionContext(apiVersion, kind, this);
        if (context == null) {
            throw new KubernetesClientException("Could not find the metadata for the given apiVersion and kind, please pass a ResourceDefinitionContext instead");
        }
        return this.genericKubernetesResources(context);
    }

    @Override
    public MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> genericKubernetesResources(ResourceDefinitionContext context) {
        return this.newHasMetadataOperation(context, GenericKubernetesResource.class, GenericKubernetesResourceList.class);
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.adapt(DiscoveryAPIGroupClient.class);
    }

    @Override
    public DynamicResourceAllocationAPIGroupDSL dynamicResourceAllocation() {
        return this.adapt(DynamicResourceAllocationAPIGroupClient.class);
    }

    @Override
    public EventingAPIGroupDSL events() {
        return this.adapt(EventingAPIGroupClient.class);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return this.newClient(this.createInNamespaceContext(null, true), NamespacedKubernetesClient.class);
    }

    @Override
    protected KubernetesClientImpl copy() {
        return new KubernetesClientImpl(this);
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public FlowControlAPIGroupDSL flowControl() {
        return this.adapt(FlowControlAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return this.getVersionInfo(KUBERNETES_VERSION_ENDPOINT);
    }

    @Override
    public VersionInfo getKubernetesVersion() {
        return this.getVersionInfo(KUBERNETES_VERSION_ENDPOINT);
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.adapt(V1APIGroupClient.class);
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.adapt(AdmissionRegistrationAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactoryImpl(this);
    }

    @Override
    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return this.resources(Lease.class, LeaseList.class);
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this, new RunConfigBuilder().build());
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return this.resources(RuntimeClass.class, RuntimeClassList.class);
    }

    @Override
    public Client newClient(RequestConfig requestConfig) {
        return this.newClient(HasMetadataOperationsImpl.defaultContext(this).withRequestConfig(requestConfig), Client.class);
    }

    @Override
    public void visitResources(ApiVisitor visitor) {
        if (this.visitGroups(visitor, Arrays.asList(((APIGroupBuilder)((APIGroupBuilder)new APIGroupBuilder().withName("")).withVersions(((GroupVersionForDiscoveryBuilder)new GroupVersionForDiscoveryBuilder().withGroupVersion("v1")).build())).build()))) {
            return;
        }
        APIGroupList apiGroups = this.getApiGroups();
        if (apiGroups != null) {
            this.visitGroups(visitor, apiGroups.getGroups());
        }
    }

    private boolean visitGroups(ApiVisitor visitor, List<APIGroup> groups) {
        for (APIGroup group : groups) {
            switch (visitor.visitApiGroup(group.getName())) {
                case TERMINATE: {
                    return true;
                }
                case SKIP: {
                    break;
                }
                case CONTINUE: {
                    for (GroupVersionForDiscovery groupForDiscovery : group.getVersions()) {
                        String groupVersion = groupForDiscovery.getGroupVersion();
                        String groupName = Utils.getNonNullOrElse(ApiVersionUtil.trimGroupOrNull(groupVersion), "");
                        String version = ApiVersionUtil.trimVersion(groupVersion);
                        ApiVisitor.ApiVisitResult versionResult = visitor.visitApiGroupVersion(groupName, version);
                        switch (versionResult) {
                            case TERMINATE: {
                                return true;
                            }
                            case SKIP: {
                                break;
                            }
                            case CONTINUE: {
                                APIResourceList apiResources = this.getApiResources(groupVersion);
                                if (apiResources == null) {
                                    if (!logger.isDebugEnabled()) break;
                                    logger.debug("{} is discoverable, but is not yet populating an APIResource list", (Object)groupVersion);
                                    break;
                                }
                                for (APIResource resource : apiResources.getResources()) {
                                    ApiVisitor.ApiVisitResult resourceResult;
                                    if (resource.getName().contains("/") || (resourceResult = visitor.visitResource(groupName, version, resource, this.genericKubernetesResources(ResourceDefinitionContext.fromApiResource(groupVersion, resource)))) != ApiVisitor.ApiVisitResult.TERMINATE) continue;
                                    return true;
                                }
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
        return false;
    }
}

