/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSecurityContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SELinuxOptions;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SELinuxOptionsFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SeccompProfile;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SeccompProfileBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SeccompProfileFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Sysctl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SysctlBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SysctlFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent;

public class PodSecurityContextFluent<A extends PodSecurityContextFluent<A>>
extends BaseFluent<A> {
    private Long fsGroup;
    private String fsGroupChangePolicy;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private SELinuxOptionsBuilder seLinuxOptions;
    private SeccompProfileBuilder seccompProfile;
    private List<Long> supplementalGroups = new ArrayList<Long>();
    private ArrayList<SysctlBuilder> sysctls = new ArrayList();
    private WindowsSecurityContextOptionsBuilder windowsOptions;
    private Map<String, Object> additionalProperties;

    public PodSecurityContextFluent() {
    }

    public PodSecurityContextFluent(PodSecurityContext instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodSecurityContext instance) {
        PodSecurityContext podSecurityContext = instance = instance != null ? instance : new PodSecurityContext();
        if (instance != null) {
            this.withFsGroup(instance.getFsGroup());
            this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
            this.withRunAsGroup(instance.getRunAsGroup());
            this.withRunAsNonRoot(instance.getRunAsNonRoot());
            this.withRunAsUser(instance.getRunAsUser());
            this.withSeLinuxOptions(instance.getSeLinuxOptions());
            this.withSeccompProfile(instance.getSeccompProfile());
            this.withSupplementalGroups(instance.getSupplementalGroups());
            this.withSysctls(instance.getSysctls());
            this.withWindowsOptions(instance.getWindowsOptions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getFsGroup() {
        return this.fsGroup;
    }

    public A withFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return (A)this;
    }

    public boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public A withFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
        return (A)this;
    }

    public boolean hasFsGroupChangePolicy() {
        return this.fsGroupChangePolicy != null;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    public boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    public boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    public boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this._visitables.remove("seLinuxOptions");
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get("seLinuxOptions").add(this.seLinuxOptions);
        } else {
            this.seLinuxOptions = null;
            this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        }
        return (A)this;
    }

    public boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    public A withNewSeLinuxOptions(String level, String role, String type, String user) {
        return this.withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNested(null);
    }

    public SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNested(item);
    }

    public SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(null));
    }

    public SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(new SELinuxOptionsBuilder().build()));
    }

    public SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(item));
    }

    public SeccompProfile buildSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    public A withSeccompProfile(SeccompProfile seccompProfile) {
        this._visitables.remove("seccompProfile");
        if (seccompProfile != null) {
            this.seccompProfile = new SeccompProfileBuilder(seccompProfile);
            this._visitables.get("seccompProfile").add(this.seccompProfile);
        } else {
            this.seccompProfile = null;
            this._visitables.get("seccompProfile").remove(this.seccompProfile);
        }
        return (A)this;
    }

    public boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    public A withNewSeccompProfile(String localhostProfile, String type) {
        return this.withSeccompProfile(new SeccompProfile(localhostProfile, type));
    }

    public SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNested(null);
    }

    public SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
        return new SeccompProfileNested(item);
    }

    public SeccompProfileNested<A> editSeccompProfile() {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(null));
    }

    public SeccompProfileNested<A> editOrNewSeccompProfile() {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(new SeccompProfileBuilder().build()));
    }

    public SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(item));
    }

    public A addToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(index, item);
        return (A)this;
    }

    public A setToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.set(index, item);
        return (A)this;
    }

    public A addToSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    public A addAllToSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    public A removeFromSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            return (A)this;
        }
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            return (A)this;
        }
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public Long getSupplementalGroup(int index) {
        return this.supplementalGroups.get(index);
    }

    public Long getFirstSupplementalGroup() {
        return this.supplementalGroups.get(0);
    }

    public Long getLastSupplementalGroup() {
        return this.supplementalGroups.get(this.supplementalGroups.size() - 1);
    }

    public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSupplementalGroups(List<Long> supplementalGroups) {
        if (supplementalGroups != null) {
            this.supplementalGroups = new ArrayList<Long>();
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        } else {
            this.supplementalGroups = null;
        }
        return (A)this;
    }

    public A withSupplementalGroups(Long ... supplementalGroups) {
        if (this.supplementalGroups != null) {
            this.supplementalGroups.clear();
            this._visitables.remove("supplementalGroups");
        }
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasSupplementalGroups() {
        return this.supplementalGroups != null && !this.supplementalGroups.isEmpty();
    }

    public A addToSysctls(int index, Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        SysctlBuilder builder = new SysctlBuilder(item);
        if (index < 0 || index >= this.sysctls.size()) {
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        } else {
            this._visitables.get("sysctls").add(index, builder);
            this.sysctls.add(index, builder);
        }
        return (A)this;
    }

    public A setToSysctls(int index, Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        SysctlBuilder builder = new SysctlBuilder(item);
        if (index < 0 || index >= this.sysctls.size()) {
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        } else {
            this._visitables.get("sysctls").set(index, builder);
            this.sysctls.set(index, builder);
        }
        return (A)this;
    }

    public A addToSysctls(Sysctl ... items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    public A addAllToSysctls(Collection<Sysctl> items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    public A removeFromSysctls(Sysctl ... items) {
        if (this.sysctls == null) {
            return (A)this;
        }
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.get("sysctls").remove(builder);
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSysctls(Collection<Sysctl> items) {
        if (this.sysctls == null) {
            return (A)this;
        }
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.get("sysctls").remove(builder);
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSysctls(Predicate<SysctlBuilder> predicate) {
        if (this.sysctls == null) {
            return (A)this;
        }
        Iterator<SysctlBuilder> each = this.sysctls.iterator();
        Object visitables = this._visitables.get("sysctls");
        while (each.hasNext()) {
            SysctlBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Sysctl> buildSysctls() {
        return this.sysctls != null ? PodSecurityContextFluent.build(this.sysctls) : null;
    }

    public Sysctl buildSysctl(int index) {
        return this.sysctls.get(index).build();
    }

    public Sysctl buildFirstSysctl() {
        return this.sysctls.get(0).build();
    }

    public Sysctl buildLastSysctl() {
        return this.sysctls.get(this.sysctls.size() - 1).build();
    }

    public Sysctl buildMatchingSysctl(Predicate<SysctlBuilder> predicate) {
        for (SysctlBuilder item : this.sysctls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSysctl(Predicate<SysctlBuilder> predicate) {
        for (SysctlBuilder item : this.sysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSysctls(List<Sysctl> sysctls) {
        if (this.sysctls != null) {
            this._visitables.get("sysctls").clear();
        }
        if (sysctls != null) {
            this.sysctls = new ArrayList();
            for (Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        } else {
            this.sysctls = null;
        }
        return (A)this;
    }

    public A withSysctls(Sysctl ... sysctls) {
        if (this.sysctls != null) {
            this.sysctls.clear();
            this._visitables.remove("sysctls");
        }
        if (sysctls != null) {
            for (Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        }
        return (A)this;
    }

    public boolean hasSysctls() {
        return this.sysctls != null && !this.sysctls.isEmpty();
    }

    public A addNewSysctl(String name, String value) {
        return this.addToSysctls(new Sysctl(name, value));
    }

    public SysctlsNested<A> addNewSysctl() {
        return new SysctlsNested(-1, null);
    }

    public SysctlsNested<A> addNewSysctlLike(Sysctl item) {
        return new SysctlsNested(-1, item);
    }

    public SysctlsNested<A> setNewSysctlLike(int index, Sysctl item) {
        return new SysctlsNested(index, item);
    }

    public SysctlsNested<A> editSysctl(int index) {
        if (this.sysctls.size() <= index) {
            throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public SysctlsNested<A> editFirstSysctl() {
        if (this.sysctls.size() == 0) {
            throw new RuntimeException("Can't edit first sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(0, this.buildSysctl(0));
    }

    public SysctlsNested<A> editLastSysctl() {
        int index = this.sysctls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public SysctlsNested<A> editMatchingSysctl(Predicate<SysctlBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sysctls.size(); ++i) {
            if (!predicate.test(this.sysctls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sysctls. No match found.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions) {
        this._visitables.remove("windowsOptions");
        if (windowsOptions != null) {
            this.windowsOptions = new WindowsSecurityContextOptionsBuilder(windowsOptions);
            this._visitables.get("windowsOptions").add(this.windowsOptions);
        } else {
            this.windowsOptions = null;
            this._visitables.get("windowsOptions").remove(this.windowsOptions);
        }
        return (A)this;
    }

    public boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    public A withNewWindowsOptions(String gmsaCredentialSpec, String gmsaCredentialSpecName, Boolean hostProcess, String runAsUserName) {
        return this.withWindowsOptions(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, hostProcess, runAsUserName));
    }

    public WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNested(null);
    }

    public WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
        return new WindowsOptionsNested(item);
    }

    public WindowsOptionsNested<A> editWindowsOptions() {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(null));
    }

    public WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(new WindowsSecurityContextOptionsBuilder().build()));
    }

    public WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityContextFluent that = (PodSecurityContextFluent)o;
        if (!Objects.equals(this.fsGroup, that.fsGroup)) {
            return false;
        }
        if (!Objects.equals(this.fsGroupChangePolicy, that.fsGroupChangePolicy)) {
            return false;
        }
        if (!Objects.equals(this.runAsGroup, that.runAsGroup)) {
            return false;
        }
        if (!Objects.equals(this.runAsNonRoot, that.runAsNonRoot)) {
            return false;
        }
        if (!Objects.equals(this.runAsUser, that.runAsUser)) {
            return false;
        }
        if (!Objects.equals(this.seLinuxOptions, that.seLinuxOptions)) {
            return false;
        }
        if (!Objects.equals(this.seccompProfile, that.seccompProfile)) {
            return false;
        }
        if (!Objects.equals(this.supplementalGroups, that.supplementalGroups)) {
            return false;
        }
        if (!Objects.equals(this.sysctls, that.sysctls)) {
            return false;
        }
        if (!Objects.equals(this.windowsOptions, that.windowsOptions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsGroup, this.fsGroupChangePolicy, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.supplementalGroups, this.sysctls, this.windowsOptions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsGroup != null) {
            sb.append("fsGroup:");
            sb.append(this.fsGroup + ",");
        }
        if (this.fsGroupChangePolicy != null) {
            sb.append("fsGroupChangePolicy:");
            sb.append(this.fsGroupChangePolicy + ",");
        }
        if (this.runAsGroup != null) {
            sb.append("runAsGroup:");
            sb.append(this.runAsGroup + ",");
        }
        if (this.runAsNonRoot != null) {
            sb.append("runAsNonRoot:");
            sb.append(this.runAsNonRoot + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser + ",");
        }
        if (this.seLinuxOptions != null) {
            sb.append("seLinuxOptions:");
            sb.append(this.seLinuxOptions + ",");
        }
        if (this.seccompProfile != null) {
            sb.append("seccompProfile:");
            sb.append(this.seccompProfile + ",");
        }
        if (this.supplementalGroups != null && !this.supplementalGroups.isEmpty()) {
            sb.append("supplementalGroups:");
            sb.append(this.supplementalGroups + ",");
        }
        if (this.sysctls != null && !this.sysctls.isEmpty()) {
            sb.append("sysctls:");
            sb.append(this.sysctls + ",");
        }
        if (this.windowsOptions != null) {
            sb.append("windowsOptions:");
            sb.append(this.windowsOptions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withRunAsNonRoot() {
        return this.withRunAsNonRoot(true);
    }

    public class WindowsOptionsNested<N>
    extends WindowsSecurityContextOptionsFluent<WindowsOptionsNested<N>>
    implements Nested<N> {
        WindowsSecurityContextOptionsBuilder builder;

        WindowsOptionsNested(WindowsSecurityContextOptions item) {
            this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluent.this.withWindowsOptions(this.builder.build());
        }

        public N endWindowsOptions() {
            return this.and();
        }
    }

    public class SysctlsNested<N>
    extends SysctlFluent<SysctlsNested<N>>
    implements Nested<N> {
        SysctlBuilder builder;
        int index;

        SysctlsNested(int index, Sysctl item) {
            this.index = index;
            this.builder = new SysctlBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluent.this.setToSysctls(this.index, this.builder.build());
        }

        public N endSysctl() {
            return this.and();
        }
    }

    public class SeccompProfileNested<N>
    extends SeccompProfileFluent<SeccompProfileNested<N>>
    implements Nested<N> {
        SeccompProfileBuilder builder;

        SeccompProfileNested(SeccompProfile item) {
            this.builder = new SeccompProfileBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluent.this.withSeccompProfile(this.builder.build());
        }

        public N endSeccompProfile() {
            return this.and();
        }
    }

    public class SeLinuxOptionsNested<N>
    extends SELinuxOptionsFluent<SeLinuxOptionsNested<N>>
    implements Nested<N> {
        SELinuxOptionsBuilder builder;

        SeLinuxOptionsNested(SELinuxOptions item) {
            this.builder = new SELinuxOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluent.this.withSeLinuxOptions(this.builder.build());
        }

        public N endSeLinuxOptions() {
            return this.and();
        }
    }
}

