/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPGetAction;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPHeader;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPHeaderBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HTTPHeaderFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.IntOrString;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.IntOrStringFluent;

public class HTTPGetActionFluent<A extends HTTPGetActionFluent<A>>
extends BaseFluent<A> {
    private String host;
    private ArrayList<HTTPHeaderBuilder> httpHeaders = new ArrayList();
    private String path;
    private IntOrStringBuilder port;
    private String scheme;
    private Map<String, Object> additionalProperties;

    public HTTPGetActionFluent() {
    }

    public HTTPGetActionFluent(HTTPGetAction instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPGetAction instance) {
        HTTPGetAction hTTPGetAction = instance = instance != null ? instance : new HTTPGetAction();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withHttpHeaders(instance.getHttpHeaders());
            this.withPath(instance.getPath());
            this.withPort(instance.getPort());
            this.withScheme(instance.getScheme());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public A addToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get("httpHeaders").add(index, builder);
            this.httpHeaders.add(index, builder);
        }
        return (A)this;
    }

    public A setToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get("httpHeaders").set(index, builder);
            this.httpHeaders.set(index, builder);
        }
        return (A)this;
    }

    public A addToHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    public A addAllToHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    public A removeFromHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        Iterator<HTTPHeaderBuilder> each = this.httpHeaders.iterator();
        Object visitables = this._visitables.get("httpHeaders");
        while (each.hasNext()) {
            HTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HTTPHeader> buildHttpHeaders() {
        return this.httpHeaders != null ? HTTPGetActionFluent.build(this.httpHeaders) : null;
    }

    public HTTPHeader buildHttpHeader(int index) {
        return this.httpHeaders.get(index).build();
    }

    public HTTPHeader buildFirstHttpHeader() {
        return this.httpHeaders.get(0).build();
    }

    public HTTPHeader buildLastHttpHeader() {
        return this.httpHeaders.get(this.httpHeaders.size() - 1).build();
    }

    public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
        if (this.httpHeaders != null) {
            this._visitables.get("httpHeaders").clear();
        }
        if (httpHeaders != null) {
            this.httpHeaders = new ArrayList();
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        } else {
            this.httpHeaders = null;
        }
        return (A)this;
    }

    public A withHttpHeaders(HTTPHeader ... httpHeaders) {
        if (this.httpHeaders != null) {
            this.httpHeaders.clear();
            this._visitables.remove("httpHeaders");
        }
        if (httpHeaders != null) {
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)this;
    }

    public boolean hasHttpHeaders() {
        return this.httpHeaders != null && !this.httpHeaders.isEmpty();
    }

    public A addNewHttpHeader(String name, String value) {
        return this.addToHttpHeaders(new HTTPHeader(name, value));
    }

    public HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNested(-1, null);
    }

    public HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
        return new HttpHeadersNested(-1, item);
    }

    public HttpHeadersNested<A> setNewHttpHeaderLike(int index, HTTPHeader item) {
        return new HttpHeadersNested(index, item);
    }

    public HttpHeadersNested<A> editHttpHeader(int index) {
        if (this.httpHeaders.size() <= index) {
            throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public HttpHeadersNested<A> editFirstHttpHeader() {
        if (this.httpHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(0, this.buildHttpHeader(0));
    }

    public HttpHeadersNested<A> editLastHttpHeader() {
        int index = this.httpHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpHeaders.size(); ++i) {
            if (!predicate.test(this.httpHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(IntOrString port) {
        this._visitables.remove("port");
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get("port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get("port").remove(this.port);
        }
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(Object value) {
        return this.withPort(new IntOrString(value));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new IntOrStringBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public String getScheme() {
        return this.scheme;
    }

    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    public boolean hasScheme() {
        return this.scheme != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPGetActionFluent that = (HTTPGetActionFluent)o;
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.httpHeaders, that.httpHeaders)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.scheme, that.scheme)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.httpHeaders != null && !this.httpHeaders.isEmpty()) {
            sb.append("httpHeaders:");
            sb.append(this.httpHeaders + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortNested<N>
    extends IntOrStringFluent<PortNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        PortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPGetActionFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class HttpHeadersNested<N>
    extends HTTPHeaderFluent<HttpHeadersNested<N>>
    implements Nested<N> {
        HTTPHeaderBuilder builder;
        int index;

        HttpHeadersNested(int index, HTTPHeader item) {
            this.index = index;
            this.builder = new HTTPHeaderBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPGetActionFluent.this.setToHttpHeaders(this.index, this.builder.build());
        }

        public N endHttpHeader() {
            return this.and();
        }
    }
}

