/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.configuration.KubernetesLeaderElectionConfiguration;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderElector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesLeaderElector {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesLeaderElector.class);
    @VisibleForTesting
    public static final String LEADER_ANNOTATION_KEY = "control-plane.alpha.kubernetes.io/leader";
    private final Object lock = new Object();
    private final NamespacedKubernetesClient kubernetesClient;
    private final LeaderElectionConfig leaderElectionConfig;
    private final ExecutorService executorService;
    private CompletableFuture<?> currentLeaderElectionSession = FutureUtils.completedVoidFuture();

    public KubernetesLeaderElector(NamespacedKubernetesClient kubernetesClient, KubernetesLeaderElectionConfiguration leaderConfig, LeaderCallbackHandler leaderCallbackHandler) {
        this(kubernetesClient, leaderConfig, leaderCallbackHandler, Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("KubernetesLeaderElector-ExecutorService")));
    }

    @VisibleForTesting
    public KubernetesLeaderElector(NamespacedKubernetesClient kubernetesClient, KubernetesLeaderElectionConfiguration leaderConfig, LeaderCallbackHandler leaderCallbackHandler, ExecutorService executorService) {
        this.kubernetesClient = kubernetesClient;
        this.leaderElectionConfig = ((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)new LeaderElectionConfigBuilder().withName(leaderConfig.getConfigMapName())).withLeaseDuration(leaderConfig.getLeaseDuration())).withLock(new ConfigMapLock(((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(kubernetesClient.getNamespace())).withName(leaderConfig.getConfigMapName())).withLabels(KubernetesUtils.getConfigMapLabels(leaderConfig.getClusterId(), "high-availability"))).build(), leaderConfig.getLockIdentity()))).withRenewDeadline(leaderConfig.getRenewDeadline())).withRetryPeriod(leaderConfig.getRetryPeriod())).withReleaseOnCancel(true)).withLeaderCallbacks(new LeaderCallbacks(leaderCallbackHandler::isLeader, leaderCallbackHandler::notLeader, newLeader -> LOG.info("New leader elected {} for {}.", newLeader, (Object)leaderConfig.getConfigMapName())))).build();
        this.executorService = executorService;
        LOG.info("Create KubernetesLeaderElector on lock {}.", (Object)this.leaderElectionConfig.getLock().describe());
    }

    @GuardedBy(value="lock")
    private void resetInternalLeaderElector() {
        this.cancelCurrentLeaderElectionSession();
        this.currentLeaderElectionSession = new LeaderElector(this.kubernetesClient, this.leaderElectionConfig, this.executorService).start();
        LOG.info("Triggered leader election on lock {}.", (Object)this.leaderElectionConfig.getLock().describe());
    }

    @GuardedBy(value="lock")
    private void cancelCurrentLeaderElectionSession() {
        this.currentLeaderElectionSession.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (this.executorService.isShutdown()) {
                LOG.debug("Ignoring KubernetesLeaderElector.run call because the leader elector has already been shut down.");
            } else {
                this.resetInternalLeaderElector();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelCurrentLeaderElectionSession();
            List outStandingTasks = ExecutorUtils.gracefulShutdown((long)30L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{this.executorService});
            if (!outStandingTasks.isEmpty()) {
                LOG.warn("{} events were not processed before stopping the {} instance.", (Object)outStandingTasks.size(), (Object)KubernetesLeaderElector.class.getSimpleName());
            }
        }
    }

    public static boolean hasLeadership(KubernetesConfigMap configMap, String lockIdentity) {
        String leader = configMap.getAnnotations().get(LEADER_ANNOTATION_KEY);
        return leader != null && leader.contains(lockIdentity);
    }

    public static abstract class LeaderCallbackHandler {
        public abstract void isLeader();

        public abstract void notLeader();
    }
}

