/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesResource;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesTooOldResourceVersionException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Watcher;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.WatcherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKubernetesWatcher<T extends HasMetadata, K extends KubernetesResource<T>>
implements Watcher<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FlinkKubeClient.WatchCallbackHandler<K> callbackHandler;

    AbstractKubernetesWatcher(FlinkKubeClient.WatchCallbackHandler<K> callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public void onClose(WatcherException cause) {
        if (cause == null) {
            this.logger.info("The watcher is closing.");
        } else if (cause.isHttpGone()) {
            this.logger.debug("Got a http code 'HTTP_GONE' which means the Kubernetes client has the too old resource version.", (Throwable)cause);
            this.callbackHandler.handleError((Throwable)((Object)new KubernetesTooOldResourceVersionException(cause)));
        } else {
            this.callbackHandler.handleError(cause);
        }
    }
}

