/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.KubernetesJobManagerSpecification;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.CmdJobManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.EnvSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.ExternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.FlinkConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.HadoopConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.InitJobManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.InternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KerberosMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.MountSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.PodTemplateMountDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesOwnerReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.OwnerReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class KubernetesJobManagerFactory {
    public static KubernetesJobManagerSpecification buildKubernetesJobManagerSpecification(FlinkPod podTemplate, KubernetesJobManagerParameters kubernetesJobManagerParameters) throws IOException {
        FlinkPod flinkPod = ((FlinkPod)Preconditions.checkNotNull((Object)podTemplate)).copy();
        ArrayList<HasMetadata> accompanyingResources = new ArrayList<HasMetadata>();
        ArrayList<AbstractKubernetesStepDecorator> stepDecorators = new ArrayList<AbstractKubernetesStepDecorator>(Arrays.asList(new InitJobManagerDecorator(kubernetesJobManagerParameters), new EnvSecretsDecorator(kubernetesJobManagerParameters), new MountSecretsDecorator(kubernetesJobManagerParameters), new CmdJobManagerDecorator(kubernetesJobManagerParameters), new InternalServiceDecorator(kubernetesJobManagerParameters), new ExternalServiceDecorator(kubernetesJobManagerParameters)));
        Configuration configuration = kubernetesJobManagerParameters.getFlinkConfiguration();
        if (((Boolean)configuration.get(KubernetesConfigOptions.KUBERNETES_HADOOP_CONF_MOUNT_DECORATOR_ENABLED)).booleanValue()) {
            stepDecorators.add(new HadoopConfMountDecorator(kubernetesJobManagerParameters));
        }
        if (((Boolean)configuration.get(KubernetesConfigOptions.KUBERNETES_KERBEROS_MOUNT_DECORATOR_ENABLED)).booleanValue()) {
            stepDecorators.add(new KerberosMountDecorator(kubernetesJobManagerParameters));
        }
        stepDecorators.addAll(Arrays.asList(new FlinkConfMountDecorator(kubernetesJobManagerParameters), new PodTemplateMountDecorator(kubernetesJobManagerParameters)));
        for (KubernetesStepDecorator kubernetesStepDecorator : stepDecorators) {
            flinkPod = kubernetesStepDecorator.decorateFlinkPod(flinkPod);
            accompanyingResources.addAll(kubernetesStepDecorator.buildAccompanyingKubernetesResources());
        }
        Deployment deployment = KubernetesJobManagerFactory.createJobManagerDeployment(flinkPod, kubernetesJobManagerParameters);
        return new KubernetesJobManagerSpecification(deployment, accompanyingResources);
    }

    private static Deployment createJobManagerDeployment(FlinkPod flinkPod, KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        Container resolvedMainContainer = flinkPod.getMainContainer();
        Pod resolvedPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(flinkPod.getPodWithoutMainContainer()).editOrNewSpec().addToContainers(resolvedMainContainer)).endSpec()).build();
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((DeploymentSpecFluent.TemplateNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentBuilder)new DeploymentBuilder().withApiVersion("apps/v1")).editOrNewMetadata().withName(KubernetesUtils.getDeploymentName(kubernetesJobManagerParameters.getClusterId()))).withAnnotations(kubernetesJobManagerParameters.getAnnotations())).withLabels(kubernetesJobManagerParameters.getLabels())).withOwnerReferences(kubernetesJobManagerParameters.getOwnerReference().stream().map(e -> (OwnerReference)KubernetesOwnerReference.fromMap(e).getInternalResource()).collect(Collectors.toList()))).endMetadata()).editOrNewSpec().withReplicas(kubernetesJobManagerParameters.getReplicas())).editOrNewTemplate().withMetadata(resolvedPod.getMetadata())).withSpec(resolvedPod.getSpec())).endTemplate()).editOrNewSelector().addToMatchLabels(kubernetesJobManagerParameters.getSelectors())).endSelector()).endSpec()).build();
    }
}

