/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;

public class RequestConfig {
    private String impersonateUsername;
    private String[] impersonateGroups = new String[0];
    private Map<String, List<String>> impersonateExtras = new HashMap<String, List<String>>();
    private int watchReconnectInterval = 1000;
    private int watchReconnectLimit = -1;
    private int uploadRequestTimeout = 120000;
    private int requestRetryBackoffLimit = Config.DEFAULT_REQUEST_RETRY_BACKOFFLIMIT;
    private int requestRetryBackoffInterval = Config.DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL;
    private int requestTimeout = 10000;
    private long scaleTimeout = Config.DEFAULT_SCALE_TIMEOUT;
    private int loggingInterval = 20000;

    RequestConfig() {
    }

    public RequestConfig(int watchReconnectLimit, int watchReconnectInterval, int requestTimeout, long scaleTimeout, int loggingInterval, int requestRetryBackoffLimit, int requestRetryBackoffInterval, int uploadRequestTimeout) {
        this.watchReconnectLimit = watchReconnectLimit;
        this.watchReconnectInterval = watchReconnectInterval;
        this.requestTimeout = requestTimeout;
        this.scaleTimeout = scaleTimeout;
        this.loggingInterval = loggingInterval;
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
        this.uploadRequestTimeout = uploadRequestTimeout;
    }

    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public void setWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
    }

    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public void setWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit;
    }

    public void setRequestRetryBackoffLimit(int requestRetryBackoffLimit) {
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
    }

    public int getRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval;
    }

    public void setRequestRetryBackoffInterval(int requestRetryBackoffInterval) {
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
    }

    public int getUploadRequestTimeout() {
        return this.uploadRequestTimeout;
    }

    public void setUploadRequestTimeout(int uploadRequestTimeout) {
        this.uploadRequestTimeout = uploadRequestTimeout;
    }

    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    public void setScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public void setImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
    }

    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    public void setImpersonateGroups(String ... impersonateGroups) {
        this.impersonateGroups = impersonateGroups == null ? new String[]{} : Arrays.copyOf(impersonateGroups, impersonateGroups.length);
    }

    public String[] getImpersonateGroups() {
        return this.impersonateGroups;
    }

    public void setImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = new HashMap<String, List<String>>(impersonateExtras);
    }

    public Map<String, List<String>> getImpersonateExtras() {
        return Collections.unmodifiableMap(this.impersonateExtras);
    }
}

