/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.utils;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.highavailability.KubernetesCheckpointStoreUtil;
import org.apache.flink.kubernetes.highavailability.KubernetesJobGraphStoreUtil;
import org.apache.flink.kubernetes.highavailability.KubernetesStateHandleStore;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesPod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSpecBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Quantity;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirements;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.runtime.checkpoint.CheckpointStoreUtil;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCompletedCheckpointStoreUtils;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.jobmanager.DefaultJobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphStoreUtil;
import org.apache.flink.runtime.jobmanager.JobGraphStoreWatcher;
import org.apache.flink.runtime.jobmanager.NoOpJobGraphStoreWatcher;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.filesystem.FileSystemStateStorageHelper;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesUtils.class);
    private static final YAMLMapper yamlMapper = new YAMLMapper();
    private static final String LEADER_PREFIX = "org.apache.flink.k8s.leader.";
    private static final char LEADER_INFORMATION_SEPARATOR = ',';

    public static void checkAndUpdatePortConfigOption(Configuration flinkConfig, ConfigOption<String> port, int fallbackPort) {
        if (KubernetesUtils.parsePort(flinkConfig, port) == 0) {
            flinkConfig.setString(port, String.valueOf(fallbackPort));
            LOG.info("Kubernetes deployment requires a fixed port. Configuration {} will be set to {}", (Object)port.key(), (Object)fallbackPort);
        }
    }

    public static Integer parsePort(Configuration flinkConfig, ConfigOption<String> port) {
        Preconditions.checkNotNull((Object)flinkConfig.get(port), (String)(port.key() + " should not be null."));
        try {
            return Integer.parseInt((String)flinkConfig.get(port));
        }
        catch (NumberFormatException ex) {
            throw new FlinkRuntimeException(port.key() + " should be specified to a fixed port. Do not support a range of ports.", (Throwable)ex);
        }
    }

    public static String getDeploymentName(String clusterId) {
        return clusterId;
    }

    public static Map<String, String> getTaskManagerSelectors(String clusterId) {
        Map<String, String> labels = KubernetesUtils.getCommonLabels(clusterId);
        labels.put("component", "taskmanager");
        return Collections.unmodifiableMap(labels);
    }

    public static Map<String, String> getJobManagerSelectors(String clusterId) {
        Map<String, String> labels = KubernetesUtils.getCommonLabels(clusterId);
        labels.put("component", "jobmanager");
        return Collections.unmodifiableMap(labels);
    }

    public static Map<String, String> getCommonLabels(String clusterId) {
        HashMap<String, String> commonLabels = new HashMap<String, String>();
        commonLabels.put("type", "flink-native-kubernetes");
        commonLabels.put("app", clusterId);
        return commonLabels;
    }

    public static Map<String, String> getConfigMapLabels(String clusterId, String type) {
        HashMap<String, String> labels = new HashMap<String, String>(KubernetesUtils.getCommonLabels(clusterId));
        labels.put("configmap-type", type);
        return Collections.unmodifiableMap(labels);
    }

    public static KubernetesConfigMap getOnlyConfigMap(List<KubernetesConfigMap> configMaps, String expectedConfigMapName) {
        if (configMaps.size() == 1 && expectedConfigMapName.equals(configMaps.get(0).getName())) {
            return configMaps.get(0);
        }
        throw new IllegalStateException(String.format("ConfigMap list should only contain a single ConfigMap [%s].", expectedConfigMapName));
    }

    public static LeaderInformation getLeaderInformationFromConfigMap(KubernetesConfigMap configMap) {
        UUID sessionID;
        String leaderAddress = configMap.getData().get("address");
        String sessionIDStr = configMap.getData().get("sessionId");
        UUID uUID = sessionID = sessionIDStr == null ? null : UUID.fromString(sessionIDStr);
        if (leaderAddress == null && sessionIDStr == null) {
            return LeaderInformation.empty();
        }
        return LeaderInformation.known((UUID)sessionID, (String)leaderAddress);
    }

    public static JobGraphStore createJobGraphStore(Configuration configuration, FlinkKubeClient flinkKubeClient, String configMapName, String lockIdentity) throws Exception {
        KubernetesStateHandleStore<JobGraph> stateHandleStore = KubernetesUtils.createJobGraphStateHandleStore(configuration, flinkKubeClient, configMapName, lockIdentity);
        return new DefaultJobGraphStore(stateHandleStore, (JobGraphStoreWatcher)NoOpJobGraphStoreWatcher.INSTANCE, (JobGraphStoreUtil)KubernetesJobGraphStoreUtil.INSTANCE);
    }

    public static KubernetesStateHandleStore<JobGraph> createJobGraphStateHandleStore(Configuration configuration, FlinkKubeClient flinkKubeClient, String configMapName, String lockIdentity) throws Exception {
        FileSystemStateStorageHelper stateStorage = new FileSystemStateStorageHelper(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)configuration), "submittedJobGraph");
        return new KubernetesStateHandleStore<JobGraph>(flinkKubeClient, configMapName, (RetrievableStateStorageHelper<JobGraph>)stateStorage, k -> k.startsWith("jobGraph-"), lockIdentity);
    }

    public static CompletedCheckpointStore createCompletedCheckpointStore(Configuration configuration, FlinkKubeClient kubeClient, Executor executor, String configMapName, @Nullable String lockIdentity, int maxNumberOfCheckpointsToRetain, SharedStateRegistryFactory sharedStateRegistryFactory, Executor ioExecutor, RestoreMode restoreMode) throws Exception {
        FileSystemStateStorageHelper stateStorage = new FileSystemStateStorageHelper(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)configuration), "completedCheckpoint");
        KubernetesStateHandleStore stateHandleStore = new KubernetesStateHandleStore(kubeClient, configMapName, stateStorage, k -> k.startsWith("checkpointID-"), lockIdentity);
        Collection checkpoints = DefaultCompletedCheckpointStoreUtils.retrieveCompletedCheckpoints(stateHandleStore, (CheckpointStoreUtil)KubernetesCheckpointStoreUtil.INSTANCE);
        return new DefaultCompletedCheckpointStore(maxNumberOfCheckpointsToRetain, stateHandleStore, (CheckpointStoreUtil)KubernetesCheckpointStoreUtil.INSTANCE, checkpoints, sharedStateRegistryFactory.create(ioExecutor, checkpoints, restoreMode), executor);
    }

    public static ResourceRequirements getResourceRequirements(ResourceRequirements resourceRequirements, int mem, double memoryLimitFactor, double cpu, double cpuLimitFactor, Map<String, ExternalResource> externalResources, Map<String, String> externalResourceConfigKeys) {
        Quantity cpuQuantity = new Quantity(String.valueOf(cpu));
        Quantity cpuLimitQuantity = new Quantity(String.valueOf(cpu * cpuLimitFactor));
        Quantity memQuantity = new Quantity(mem + "Mi");
        Quantity memQuantityLimit = new Quantity((int)((double)mem * memoryLimitFactor) + "Mi");
        ResourceRequirementsBuilder resourceRequirementsBuilder = (ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder(resourceRequirements).addToRequests("memory", memQuantity)).addToRequests("cpu", cpuQuantity)).addToLimits("memory", memQuantityLimit)).addToLimits("cpu", cpuLimitQuantity);
        for (Map.Entry<String, ExternalResource> externalResource : externalResources.entrySet()) {
            String configKey = externalResourceConfigKeys.get(externalResource.getKey());
            if (StringUtils.isNullOrWhitespaceOnly((String)configKey)) continue;
            Quantity resourceQuantity = new Quantity(String.valueOf(externalResource.getValue().getValue().longValue()));
            ((ResourceRequirementsBuilder)resourceRequirementsBuilder.addToRequests(configKey, resourceQuantity)).addToLimits(configKey, resourceQuantity);
            LOG.info("Request external resource {} with config key {}.", (Object)resourceQuantity.getAmount(), (Object)configKey);
        }
        return resourceRequirementsBuilder.build();
    }

    public static List<String> getStartCommandWithBashWrapper(String command) {
        return Arrays.asList("bash", "-c", command);
    }

    public static List<File> checkJarFileForApplicationMode(Configuration configuration) {
        return ((List)configuration.get(PipelineOptions.JARS)).stream().map(FunctionUtils.uncheckedFunction(uri -> {
            URI jarURI = PackagedProgramUtils.resolveURI((String)uri);
            if (jarURI.getScheme().equals("local") && jarURI.isAbsolute()) {
                return new File(jarURI.getPath());
            }
            throw new IllegalArgumentException("Only \"local\" is supported as schema for application mode. This assumes that the jar is located in the image, not the Flink client. An example of such path is: local:///opt/flink/examples/streaming/WindowJoin.jar");
        })).collect(Collectors.toList());
    }

    public static FlinkPod loadPodFromTemplateFile(FlinkKubeClient kubeClient, File podTemplateFile, String mainContainerName) {
        KubernetesPod pod = kubeClient.loadPodFromTemplateFile(podTemplateFile);
        ArrayList<Container> otherContainers = new ArrayList<Container>();
        Container mainContainer = null;
        if (null != ((Pod)pod.getInternalResource()).getSpec()) {
            for (Container container : ((Pod)pod.getInternalResource()).getSpec().getContainers()) {
                if (mainContainerName.equals(container.getName())) {
                    mainContainer = container;
                    continue;
                }
                otherContainers.add(container);
            }
            ((Pod)pod.getInternalResource()).getSpec().setContainers(otherContainers);
        } else {
            ((Pod)pod.getInternalResource()).setSpec(new PodSpecBuilder().build());
        }
        if (mainContainer == null) {
            LOG.info("Could not find main container {} in pod template, using empty one to initialize.", (Object)mainContainerName);
            mainContainer = new ContainerBuilder().build();
        }
        return new FlinkPod((Pod)pod.getInternalResource(), mainContainer);
    }

    public static File getTaskManagerPodTemplateFileInPod() {
        return new File("/opt/flink/pod-template", "taskmanager-pod-template.yaml");
    }

    public static <T> String resolveUserDefinedValue(Configuration flinkConfig, ConfigOption<T> configOption, String valueOfConfigOptionOrDefault, @Nullable String valueOfPodTemplate, String fieldDescription) {
        String resolvedValue;
        if (valueOfPodTemplate != null) {
            if (flinkConfig.contains(configOption)) {
                resolvedValue = valueOfConfigOptionOrDefault;
                LOG.info("The {} configured in pod template will be overwritten to '{}' because of explicitly configured options.", (Object)fieldDescription, (Object)resolvedValue);
            } else {
                resolvedValue = valueOfPodTemplate;
            }
        } else {
            resolvedValue = valueOfConfigOptionOrDefault;
        }
        return resolvedValue;
    }

    public static String resolveDNSPolicy(String dnsPolicy, boolean hostNetworkEnabled) {
        if (hostNetworkEnabled) {
            return "ClusterFirstWithHostNet";
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)dnsPolicy)) {
            return dnsPolicy;
        }
        return "ClusterFirst";
    }

    @Nullable
    public static String getServiceAccount(FlinkPod flinkPod) {
        String serviceAccount = flinkPod.getPodWithoutMainContainer().getSpec().getServiceAccount();
        if (serviceAccount == null) {
            return flinkPod.getPodWithoutMainContainer().getSpec().getServiceAccountName();
        }
        return serviceAccount;
    }

    public static String tryToGetPrettyPrintYaml(KubernetesResource kubernetesResource) {
        try {
            return yamlMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)kubernetesResource);
        }
        catch (Exception ex) {
            LOG.debug("Failed to get the pretty print yaml, fallback to {}", (Object)kubernetesResource, (Object)ex);
            return kubernetesResource.toString();
        }
    }

    public static boolean isHostNetwork(Configuration configuration) {
        return configuration.getBoolean(KubernetesConfigOptions.KUBERNETES_HOSTNETWORK_ENABLED);
    }

    public static void createConfigMapIfItDoesNotExist(FlinkKubeClient flinkKubeClient, String configMapName, String clusterId) throws FlinkException {
        int attempt;
        CompletionException lastException = null;
        int maxAttempts = 10;
        KubernetesConfigMap configMap = new KubernetesConfigMap(((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).withLabels(KubernetesUtils.getConfigMapLabels(clusterId, "high-availability"))).endMetadata()).build());
        for (attempt = 0; !flinkKubeClient.getConfigMap(configMapName).isPresent() && attempt < 10; ++attempt) {
            try {
                flinkKubeClient.createConfigMap(configMap).join();
                continue;
            }
            catch (CompletionException e) {
                lastException = (CompletionException)ExceptionUtils.firstOrSuppressed((Throwable)e, lastException);
            }
        }
        if (attempt >= 10 && lastException != null) {
            throw new FlinkException(String.format("Could not create the config map %s.", configMapName), (Throwable)lastException);
        }
    }

    public static String encodeLeaderInformation(LeaderInformation leaderInformation) {
        Preconditions.checkArgument((leaderInformation.getLeaderSessionID() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((leaderInformation.getLeaderAddress() != null ? 1 : 0) != 0);
        return leaderInformation.getLeaderSessionID().toString() + ',' + leaderInformation.getLeaderAddress();
    }

    public static Optional<LeaderInformation> parseLeaderInformationSafely(String value) {
        try {
            return Optional.of(KubernetesUtils.parseLeaderInformation(value));
        }
        catch (Throwable throwable) {
            LOG.debug("Could not parse value {} into LeaderInformation.", (Object)value, (Object)throwable);
            return Optional.empty();
        }
    }

    private static LeaderInformation parseLeaderInformation(String value) {
        int splitIndex = value.indexOf(44);
        Preconditions.checkState((splitIndex >= 0 ? 1 : 0) != 0, (Object)String.format("Expecting '<session_id>%c<leader_address>'", Character.valueOf(',')));
        UUID leaderSessionId = UUID.fromString(value.substring(0, splitIndex));
        String leaderAddress = value.substring(splitIndex + 1);
        return LeaderInformation.known((UUID)leaderSessionId, (String)leaderAddress);
    }

    public static String createSingleLeaderKey(String componentId) {
        return LEADER_PREFIX + componentId;
    }

    public static boolean isSingleLeaderKey(String key) {
        return key.startsWith(LEADER_PREFIX);
    }

    public static String extractLeaderName(String key) {
        return key.substring(LEADER_PREFIX.length());
    }

    public static String getNamespacedServiceName(Service service) {
        return service.getMetadata().getName() + "." + service.getMetadata().getNamespace();
    }

    private KubernetesUtils() {
    }
}

