/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.runtime.RawExtension;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.model.annotation.Group;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.model.annotation.Version;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.model.util.Helper;

public class KubernetesDeserializer
extends JsonDeserializer<KubernetesResource> {
    private static final String KIND = "kind";
    private static final String API_VERSION = "apiVersion";
    private static final Mapping mapping = new Mapping();

    @Override
    public KubernetesResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        if (node.isObject()) {
            return KubernetesDeserializer.fromObjectNode(jp, node);
        }
        if (node.isArray()) {
            return this.fromArrayNode(jp, node);
        }
        Object object = node.traverse(jp.getCodec()).readValueAs(Object.class);
        if (object == null) {
            return null;
        }
        return new RawExtension(object);
    }

    private KubernetesResource fromArrayNode(JsonParser jp, JsonNode node) throws IOException {
        Iterator<JsonNode> iterator = node.elements();
        ArrayList<HasMetadata> list = new ArrayList<HasMetadata>();
        while (iterator.hasNext()) {
            JsonNode jsonNode = iterator.next();
            if (jsonNode.isObject()) {
                KubernetesResource resource = KubernetesDeserializer.fromObjectNode(jp, jsonNode);
                if (!(resource instanceof HasMetadata)) {
                    throw new JsonMappingException(jp, "Cannot parse a nested array containing a non-HasMetadata resource");
                }
                list.add((HasMetadata)resource);
                continue;
            }
            throw new JsonMappingException(jp, "Cannot parse a nested array containing non-object resource");
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(list)).build();
    }

    private static KubernetesResource fromObjectNode(JsonParser jp, JsonNode node) throws IOException {
        TypeKey key = KubernetesDeserializer.getKey(node);
        Class<? extends KubernetesResource> resourceType = mapping.getForKey(key);
        if (resourceType == null) {
            if (key == null) {
                return jp.getCodec().treeToValue(node, RawExtension.class);
            }
            return jp.getCodec().treeToValue(node, GenericKubernetesResource.class);
        }
        if (KubernetesResource.class.isAssignableFrom(resourceType)) {
            return jp.getCodec().treeToValue(node, resourceType);
        }
        throw new JsonMappingException(jp, String.format("There's a class loading issue, %s is registered as a KubernetesResource, but is not an instance of KubernetesResource", resourceType.getName()));
    }

    private static TypeKey getKey(JsonNode node) {
        JsonNode apiVersion = node.get(API_VERSION);
        JsonNode kind = node.get(KIND);
        return mapping.createKey(apiVersion != null ? apiVersion.textValue() : null, kind != null ? kind.textValue() : null);
    }

    public static void registerCustomKind(String kind, Class<? extends KubernetesResource> clazz) {
        KubernetesDeserializer.registerCustomKind(null, kind, clazz);
    }

    public static void registerCustomKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
        mapping.registerKind(apiVersion, kind, clazz);
    }

    static class Mapping {
        private Map<TypeKey, Class<? extends KubernetesResource>> mappings = new ConcurrentHashMap<TypeKey, Class<? extends KubernetesResource>>();

        Mapping() {
            this.registerClasses(Thread.currentThread().getContextClassLoader());
            this.registerClasses(KubernetesDeserializer.class.getClassLoader());
        }

        public Class<? extends KubernetesResource> getForKey(TypeKey key) {
            if (key == null) {
                return null;
            }
            return this.mappings.get(key);
        }

        public void registerKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
            Optional.ofNullable(this.createKey(apiVersion, kind)).ifPresent(k -> this.mappings.put((TypeKey)k, clazz));
        }

        TypeKey createKey(String apiVersion, String kind) {
            if (kind == null || apiVersion == null) {
                return null;
            }
            String[] versionParts = new String[]{null, apiVersion};
            if (apiVersion.contains("/")) {
                versionParts = apiVersion.split("/", 2);
            }
            return new TypeKey(kind, versionParts[0], versionParts[1]);
        }

        private void registerClasses(ClassLoader classLoader) {
            Iterable resources = () -> ServiceLoader.load(KubernetesResource.class, classLoader).iterator();
            for (KubernetesResource resource : resources) {
                this.addMapping(resource.getClass());
            }
        }

        TypeKey getKeyFromClass(Class<? extends KubernetesResource> clazz) {
            String apiGroup = Helper.getAnnotationValue(clazz, Group.class);
            String apiVersion = Helper.getAnnotationValue(clazz, Version.class);
            String kind = HasMetadata.getKind(clazz);
            if (apiGroup != null && !apiGroup.isEmpty() && apiVersion != null && !apiVersion.isEmpty()) {
                return new TypeKey(kind, apiGroup, apiVersion);
            }
            if (apiVersion != null && !apiVersion.isEmpty()) {
                return this.createKey(apiVersion, kind);
            }
            return null;
        }

        private void addMapping(Class<? extends KubernetesResource> clazz) {
            TypeKey keyFromClass = this.getKeyFromClass(clazz);
            if (keyFromClass == null) {
                return;
            }
            this.mappings.put(keyFromClass, clazz);
            if (keyFromClass.apiGroup != null && keyFromClass.apiGroup.endsWith(".openshift.io")) {
                this.mappings.putIfAbsent(new TypeKey(keyFromClass.kind, null, keyFromClass.version), clazz);
            }
        }
    }

    static class TypeKey {
        final String kind;
        final String apiGroup;
        final String version;

        TypeKey(String kind, String apiGroup, String version) {
            this.kind = kind;
            this.apiGroup = apiGroup;
            this.version = version;
        }

        public int hashCode() {
            return Objects.hash(this.kind, this.apiGroup, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeKey)) {
                return false;
            }
            TypeKey o = (TypeKey)obj;
            return Objects.equals(this.kind, o.kind) && Objects.equals(this.apiGroup, o.apiGroup) && Objects.equals(this.version, o.version);
        }
    }
}

