/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Informable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MixedOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Resource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedInformerFactoryImpl
implements SharedInformerFactory {
    private static final Logger log = LoggerFactory.getLogger(SharedInformerFactoryImpl.class);
    private final List<SharedIndexInformer<?>> informers = new ArrayList();
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners = new ConcurrentLinkedQueue();
    private String name;
    private String namespace;
    private final KubernetesClient client;

    public SharedInformerFactoryImpl(KubernetesClient client) {
        this.client = client;
    }

    @Override
    public SharedInformerFactory inNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public SharedInformerFactory withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        MixedOperation<T, KubernetesResourceList<T>, Resource<T>> resources = this.client.resources(apiTypeClass);
        Informable informable = null;
        if (this.namespace != null) {
            NonNamespaceOperation nonNamespaceOp = (NonNamespaceOperation)resources.inNamespace(this.namespace);
            informable = nonNamespaceOp;
            if (this.name != null) {
                informable = (Informable)nonNamespaceOp.withName(this.name);
            }
        } else {
            informable = this.name != null ? (Informable)resources.withName(this.name) : (Informable)resources.inAnyNamespace();
        }
        SharedIndexInformer informer = informable.runnableInformer(resyncPeriodInMillis);
        this.informers.add(informer);
        return informer;
    }

    @Override
    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        for (SharedIndexInformer<?> informer : this.informers) {
            if (!informer.getApiTypeClass().equals(apiTypeClass)) continue;
            return informer;
        }
        return null;
    }

    @Override
    public synchronized Future<Void> startAllRegisteredInformers() {
        ArrayList<CompletableFuture<Void>> startInformerTasks = new ArrayList<CompletableFuture<Void>>();
        if (!this.informers.isEmpty()) {
            for (SharedIndexInformer<?> informer : this.informers) {
                CompletableFuture<Void> future = informer.start().toCompletableFuture();
                startInformerTasks.add(future);
                future.whenComplete((v, t) -> {
                    if (t != null) {
                        if (this.eventListeners.isEmpty()) {
                            log.warn("Failed to start informer {}", (Object)informer, t);
                        } else {
                            this.eventListeners.forEach(listener -> listener.onException(informer, KubernetesClientException.launderThrowable(t)));
                        }
                    }
                });
            }
        }
        return CompletableFuture.allOf(startInformerTasks.toArray(new CompletableFuture[0]));
    }

    @Override
    public synchronized void stopAllRegisteredInformers() {
        this.informers.forEach(SharedIndexInformer::stop);
    }

    @Override
    public void addSharedInformerEventListener(SharedInformerEventListener event) {
        this.eventListeners.add(event);
    }
}

