/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal;

import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Serialization;
import org.apache.flink.kubernetes.shaded.io.fabric8.zjsonpatch.JsonDiff;

public class PatchUtils {
    private PatchUtils() {
    }

    public static String withoutRuntimeState(Object object, Format format, boolean omitStatus) {
        Function<Object, String> mapper = format == Format.JSON ? Serialization::asJson : Serialization::asYaml;
        return mapper.apply(PatchUtils.withoutRuntimeState(object, omitStatus));
    }

    static JsonNode withoutRuntimeState(Object object, boolean omitStatus) {
        ObjectNode raw = SingletonHolder.patchMapper.convertValue(object, ObjectNode.class);
        Optional.ofNullable(raw.get("metadata")).filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).ifPresent(m -> {
            m.remove("creationTimestamp");
            m.remove("deletionTimestamp");
            m.remove("generation");
            m.remove("selfLink");
            m.remove("uid");
        });
        if (omitStatus) {
            raw.remove("status");
        }
        return raw;
    }

    public static String jsonDiff(Object current, Object updated, boolean omitStatus) {
        return Serialization.asJson(JsonDiff.asJson(PatchUtils.withoutRuntimeState(current, omitStatus), PatchUtils.withoutRuntimeState(updated, omitStatus)));
    }

    private static class SingletonHolder {
        public static final ObjectMapper patchMapper = Serialization.jsonMapper().copy();

        private SingletonHolder() {
        }

        static {
            patchMapper.setConfig(patchMapper.getSerializationConfig().without(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS));
        }
    }

    public static enum Format {
        YAML,
        JSON;

    }
}

