/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.policy.v1beta1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsFluent;

public class RunAsUserStrategyOptionsFluentImpl<A extends RunAsUserStrategyOptionsFluent<A>>
extends BaseFluent<A>
implements RunAsUserStrategyOptionsFluent<A> {
    private ArrayList<IDRangeBuilder> ranges = new ArrayList();
    private String rule;
    private Map<String, Object> additionalProperties;

    public RunAsUserStrategyOptionsFluentImpl() {
    }

    public RunAsUserStrategyOptionsFluentImpl(RunAsUserStrategyOptions instance) {
        this.withRanges(instance.getRanges());
        this.withRule(instance.getRule());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToRanges(Integer index, IDRange item) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        IDRangeBuilder builder = new IDRangeBuilder(item);
        this._visitables.get("ranges").add(index >= 0 ? index.intValue() : this._visitables.get("ranges").size(), builder);
        this.ranges.add(index >= 0 ? index.intValue() : this.ranges.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRanges(Integer index, IDRange item) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        IDRangeBuilder builder = new IDRangeBuilder(item);
        if (index < 0 || index >= this._visitables.get("ranges").size()) {
            this._visitables.get("ranges").add(builder);
        } else {
            this._visitables.get("ranges").set(index, builder);
        }
        if (index < 0 || index >= this.ranges.size()) {
            this.ranges.add(builder);
        } else {
            this.ranges.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRanges(IDRange ... items) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get("ranges").add(builder);
            this.ranges.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRanges(Collection<IDRange> items) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get("ranges").add(builder);
            this.ranges.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRanges(IDRange ... items) {
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get("ranges").remove(builder);
            if (this.ranges == null) continue;
            this.ranges.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRanges(Collection<IDRange> items) {
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get("ranges").remove(builder);
            if (this.ranges == null) continue;
            this.ranges.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRanges(Predicate<IDRangeBuilder> predicate) {
        if (this.ranges == null) {
            return (A)this;
        }
        Iterator<IDRangeBuilder> each = this.ranges.iterator();
        Object visitables = this._visitables.get("ranges");
        while (each.hasNext()) {
            IDRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IDRange> getRanges() {
        return this.ranges != null ? RunAsUserStrategyOptionsFluentImpl.build(this.ranges) : null;
    }

    @Override
    public List<IDRange> buildRanges() {
        return this.ranges != null ? RunAsUserStrategyOptionsFluentImpl.build(this.ranges) : null;
    }

    @Override
    public IDRange buildRange(Integer index) {
        return this.ranges.get(index).build();
    }

    @Override
    public IDRange buildFirstRange() {
        return this.ranges.get(0).build();
    }

    @Override
    public IDRange buildLastRange() {
        return this.ranges.get(this.ranges.size() - 1).build();
    }

    @Override
    public IDRange buildMatchingRange(Predicate<IDRangeBuilder> predicate) {
        for (IDRangeBuilder item : this.ranges) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRange(Predicate<IDRangeBuilder> predicate) {
        for (IDRangeBuilder item : this.ranges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRanges(List<IDRange> ranges) {
        if (this.ranges != null) {
            this._visitables.get("ranges").removeAll(this.ranges);
        }
        if (ranges != null) {
            this.ranges = new ArrayList();
            for (IDRange item : ranges) {
                this.addToRanges(item);
            }
        } else {
            this.ranges = null;
        }
        return (A)this;
    }

    @Override
    public A withRanges(IDRange ... ranges) {
        if (this.ranges != null) {
            this.ranges.clear();
        }
        if (ranges != null) {
            for (IDRange item : ranges) {
                this.addToRanges(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRanges() {
        return this.ranges != null && !this.ranges.isEmpty();
    }

    @Override
    public A addNewRange(Long max, Long min) {
        return this.addToRanges(new IDRange(max, min));
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> addNewRange() {
        return new RangesNestedImpl();
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> addNewRangeLike(IDRange item) {
        return new RangesNestedImpl(-1, item);
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> setNewRangeLike(Integer index, IDRange item) {
        return new RangesNestedImpl(index, item);
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> editRange(Integer index) {
        if (this.ranges.size() <= index) {
            throw new RuntimeException("Can't edit ranges. Index exceeds size.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> editFirstRange() {
        if (this.ranges.size() == 0) {
            throw new RuntimeException("Can't edit first ranges. The list is empty.");
        }
        return this.setNewRangeLike(0, this.buildRange(0));
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> editLastRange() {
        int index = this.ranges.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ranges. The list is empty.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> editMatchingRange(Predicate<IDRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (!predicate.test(this.ranges.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ranges. No match found.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    @Override
    public A withRule(String rule) {
        this.rule = rule;
        return (A)this;
    }

    @Override
    public Boolean hasRule() {
        return this.rule != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunAsUserStrategyOptionsFluentImpl that = (RunAsUserStrategyOptionsFluentImpl)o;
        if (this.ranges != null ? !this.ranges.equals(that.ranges) : that.ranges != null) {
            return false;
        }
        if (this.rule != null ? !this.rule.equals(that.rule) : that.rule != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ranges, this.rule, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ranges != null && !this.ranges.isEmpty()) {
            sb.append("ranges:");
            sb.append(this.ranges + ",");
        }
        if (this.rule != null) {
            sb.append("rule:");
            sb.append(this.rule + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RangesNestedImpl<N>
    extends IDRangeFluentImpl<RunAsUserStrategyOptionsFluent.RangesNested<N>>
    implements RunAsUserStrategyOptionsFluent.RangesNested<N>,
    Nested<N> {
        IDRangeBuilder builder;
        Integer index;

        RangesNestedImpl(Integer index, IDRange item) {
            this.index = index;
            this.builder = new IDRangeBuilder(this, item);
        }

        RangesNestedImpl() {
            this.index = -1;
            this.builder = new IDRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)RunAsUserStrategyOptionsFluentImpl.this.setToRanges(this.index, this.builder.build());
        }

        @Override
        public N endRange() {
            return this.and();
        }
    }
}

