/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.AllowedRoutes;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.AllowedRoutesFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKindBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKindFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteNamespaces;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteNamespacesBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteNamespacesFluentImpl;

public class AllowedRoutesFluentImpl<A extends AllowedRoutesFluent<A>>
extends BaseFluent<A>
implements AllowedRoutesFluent<A> {
    private ArrayList<RouteGroupKindBuilder> kinds = new ArrayList();
    private RouteNamespacesBuilder namespaces;
    private Map<String, Object> additionalProperties;

    public AllowedRoutesFluentImpl() {
    }

    public AllowedRoutesFluentImpl(AllowedRoutes instance) {
        this.withKinds(instance.getKinds());
        this.withNamespaces(instance.getNamespaces());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToKinds(Integer index, RouteGroupKind item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList();
        }
        RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
        this._visitables.get("kinds").add(index >= 0 ? index.intValue() : this._visitables.get("kinds").size(), builder);
        this.kinds.add(index >= 0 ? index.intValue() : this.kinds.size(), builder);
        return (A)this;
    }

    @Override
    public A setToKinds(Integer index, RouteGroupKind item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList();
        }
        RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
        if (index < 0 || index >= this._visitables.get("kinds").size()) {
            this._visitables.get("kinds").add(builder);
        } else {
            this._visitables.get("kinds").set(index, builder);
        }
        if (index < 0 || index >= this.kinds.size()) {
            this.kinds.add(builder);
        } else {
            this.kinds.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToKinds(RouteGroupKind ... items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList();
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("kinds").add(builder);
            this.kinds.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToKinds(Collection<RouteGroupKind> items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList();
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("kinds").add(builder);
            this.kinds.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromKinds(RouteGroupKind ... items) {
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("kinds").remove(builder);
            if (this.kinds == null) continue;
            this.kinds.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromKinds(Collection<RouteGroupKind> items) {
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("kinds").remove(builder);
            if (this.kinds == null) continue;
            this.kinds.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromKinds(Predicate<RouteGroupKindBuilder> predicate) {
        if (this.kinds == null) {
            return (A)this;
        }
        Iterator<RouteGroupKindBuilder> each = this.kinds.iterator();
        Object visitables = this._visitables.get("kinds");
        while (each.hasNext()) {
            RouteGroupKindBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteGroupKind> getKinds() {
        return this.kinds != null ? AllowedRoutesFluentImpl.build(this.kinds) : null;
    }

    @Override
    public List<RouteGroupKind> buildKinds() {
        return this.kinds != null ? AllowedRoutesFluentImpl.build(this.kinds) : null;
    }

    @Override
    public RouteGroupKind buildKind(Integer index) {
        return this.kinds.get(index).build();
    }

    @Override
    public RouteGroupKind buildFirstKind() {
        return this.kinds.get(0).build();
    }

    @Override
    public RouteGroupKind buildLastKind() {
        return this.kinds.get(this.kinds.size() - 1).build();
    }

    @Override
    public RouteGroupKind buildMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
        for (RouteGroupKindBuilder item : this.kinds) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
        for (RouteGroupKindBuilder item : this.kinds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withKinds(List<RouteGroupKind> kinds) {
        if (this.kinds != null) {
            this._visitables.get("kinds").removeAll(this.kinds);
        }
        if (kinds != null) {
            this.kinds = new ArrayList();
            for (RouteGroupKind item : kinds) {
                this.addToKinds(item);
            }
        } else {
            this.kinds = null;
        }
        return (A)this;
    }

    @Override
    public A withKinds(RouteGroupKind ... kinds) {
        if (this.kinds != null) {
            this.kinds.clear();
        }
        if (kinds != null) {
            for (RouteGroupKind item : kinds) {
                this.addToKinds(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasKinds() {
        return this.kinds != null && !this.kinds.isEmpty();
    }

    @Override
    public A addNewKind(String group, String kind) {
        return this.addToKinds(new RouteGroupKind(group, kind));
    }

    @Override
    public AllowedRoutesFluent.KindsNested<A> addNewKind() {
        return new KindsNestedImpl();
    }

    @Override
    public AllowedRoutesFluent.KindsNested<A> addNewKindLike(RouteGroupKind item) {
        return new KindsNestedImpl(-1, item);
    }

    @Override
    public AllowedRoutesFluent.KindsNested<A> setNewKindLike(Integer index, RouteGroupKind item) {
        return new KindsNestedImpl(index, item);
    }

    @Override
    public AllowedRoutesFluent.KindsNested<A> editKind(Integer index) {
        if (this.kinds.size() <= index) {
            throw new RuntimeException("Can't edit kinds. Index exceeds size.");
        }
        return this.setNewKindLike(index, this.buildKind(index));
    }

    @Override
    public AllowedRoutesFluent.KindsNested<A> editFirstKind() {
        if (this.kinds.size() == 0) {
            throw new RuntimeException("Can't edit first kinds. The list is empty.");
        }
        return this.setNewKindLike(0, this.buildKind(0));
    }

    @Override
    public AllowedRoutesFluent.KindsNested<A> editLastKind() {
        int index = this.kinds.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last kinds. The list is empty.");
        }
        return this.setNewKindLike(index, this.buildKind(index));
    }

    @Override
    public AllowedRoutesFluent.KindsNested<A> editMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.kinds.size(); ++i) {
            if (!predicate.test(this.kinds.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching kinds. No match found.");
        }
        return this.setNewKindLike(index, this.buildKind(index));
    }

    @Override
    @Deprecated
    public RouteNamespaces getNamespaces() {
        return this.namespaces != null ? this.namespaces.build() : null;
    }

    @Override
    public RouteNamespaces buildNamespaces() {
        return this.namespaces != null ? this.namespaces.build() : null;
    }

    @Override
    public A withNamespaces(RouteNamespaces namespaces) {
        this._visitables.get("namespaces").remove(this.namespaces);
        if (namespaces != null) {
            this.namespaces = new RouteNamespacesBuilder(namespaces);
            this._visitables.get("namespaces").add(this.namespaces);
        } else {
            this.namespaces = null;
            this._visitables.get("namespaces").remove(this.namespaces);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null;
    }

    @Override
    public AllowedRoutesFluent.NamespacesNested<A> withNewNamespaces() {
        return new NamespacesNestedImpl();
    }

    @Override
    public AllowedRoutesFluent.NamespacesNested<A> withNewNamespacesLike(RouteNamespaces item) {
        return new NamespacesNestedImpl(item);
    }

    @Override
    public AllowedRoutesFluent.NamespacesNested<A> editNamespaces() {
        return this.withNewNamespacesLike(this.getNamespaces());
    }

    @Override
    public AllowedRoutesFluent.NamespacesNested<A> editOrNewNamespaces() {
        return this.withNewNamespacesLike(this.getNamespaces() != null ? this.getNamespaces() : new RouteNamespacesBuilder().build());
    }

    @Override
    public AllowedRoutesFluent.NamespacesNested<A> editOrNewNamespacesLike(RouteNamespaces item) {
        return this.withNewNamespacesLike(this.getNamespaces() != null ? this.getNamespaces() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllowedRoutesFluentImpl that = (AllowedRoutesFluentImpl)o;
        if (this.kinds != null ? !this.kinds.equals(that.kinds) : that.kinds != null) {
            return false;
        }
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kinds, this.namespaces, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kinds != null && !this.kinds.isEmpty()) {
            sb.append("kinds:");
            sb.append(this.kinds + ",");
        }
        if (this.namespaces != null) {
            sb.append("namespaces:");
            sb.append(this.namespaces + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class NamespacesNestedImpl<N>
    extends RouteNamespacesFluentImpl<AllowedRoutesFluent.NamespacesNested<N>>
    implements AllowedRoutesFluent.NamespacesNested<N>,
    Nested<N> {
        RouteNamespacesBuilder builder;

        NamespacesNestedImpl(RouteNamespaces item) {
            this.builder = new RouteNamespacesBuilder(this, item);
        }

        NamespacesNestedImpl() {
            this.builder = new RouteNamespacesBuilder(this);
        }

        @Override
        public N and() {
            return (N)AllowedRoutesFluentImpl.this.withNamespaces(this.builder.build());
        }

        @Override
        public N endNamespaces() {
            return this.and();
        }
    }

    class KindsNestedImpl<N>
    extends RouteGroupKindFluentImpl<AllowedRoutesFluent.KindsNested<N>>
    implements AllowedRoutesFluent.KindsNested<N>,
    Nested<N> {
        RouteGroupKindBuilder builder;
        Integer index;

        KindsNestedImpl(Integer index, RouteGroupKind item) {
            this.index = index;
            this.builder = new RouteGroupKindBuilder(this, item);
        }

        KindsNestedImpl() {
            this.index = -1;
            this.builder = new RouteGroupKindBuilder(this);
        }

        @Override
        public N and() {
            return (N)AllowedRoutesFluentImpl.this.setToKinds(this.index, this.builder.build());
        }

        @Override
        public N endKind() {
            return this.and();
        }
    }
}

