/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVar;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVarFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVarSource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVarSourceFluentImpl;

public class EnvVarFluentImpl<A extends EnvVarFluent<A>>
extends BaseFluent<A>
implements EnvVarFluent<A> {
    private String name;
    private String value;
    private EnvVarSourceBuilder valueFrom;
    private Map<String, Object> additionalProperties;

    public EnvVarFluentImpl() {
    }

    public EnvVarFluentImpl(EnvVar instance) {
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.withValueFrom(instance.getValueFrom());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    @Override
    @Deprecated
    public EnvVarSource getValueFrom() {
        return this.valueFrom != null ? this.valueFrom.build() : null;
    }

    @Override
    public EnvVarSource buildValueFrom() {
        return this.valueFrom != null ? this.valueFrom.build() : null;
    }

    @Override
    public A withValueFrom(EnvVarSource valueFrom) {
        this._visitables.get("valueFrom").remove(this.valueFrom);
        if (valueFrom != null) {
            this.valueFrom = new EnvVarSourceBuilder(valueFrom);
            this._visitables.get("valueFrom").add(this.valueFrom);
        } else {
            this.valueFrom = null;
            this._visitables.get("valueFrom").remove(this.valueFrom);
        }
        return (A)this;
    }

    @Override
    public Boolean hasValueFrom() {
        return this.valueFrom != null;
    }

    @Override
    public EnvVarFluent.ValueFromNested<A> withNewValueFrom() {
        return new ValueFromNestedImpl();
    }

    @Override
    public EnvVarFluent.ValueFromNested<A> withNewValueFromLike(EnvVarSource item) {
        return new ValueFromNestedImpl(item);
    }

    @Override
    public EnvVarFluent.ValueFromNested<A> editValueFrom() {
        return this.withNewValueFromLike(this.getValueFrom());
    }

    @Override
    public EnvVarFluent.ValueFromNested<A> editOrNewValueFrom() {
        return this.withNewValueFromLike(this.getValueFrom() != null ? this.getValueFrom() : new EnvVarSourceBuilder().build());
    }

    @Override
    public EnvVarFluent.ValueFromNested<A> editOrNewValueFromLike(EnvVarSource item) {
        return this.withNewValueFromLike(this.getValueFrom() != null ? this.getValueFrom() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvVarFluentImpl that = (EnvVarFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.valueFrom != null ? !this.valueFrom.equals(that.valueFrom) : that.valueFrom != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value, this.valueFrom, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.valueFrom != null) {
            sb.append("valueFrom:");
            sb.append(this.valueFrom + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ValueFromNestedImpl<N>
    extends EnvVarSourceFluentImpl<EnvVarFluent.ValueFromNested<N>>
    implements EnvVarFluent.ValueFromNested<N>,
    Nested<N> {
        EnvVarSourceBuilder builder;

        ValueFromNestedImpl(EnvVarSource item) {
            this.builder = new EnvVarSourceBuilder(this, item);
        }

        ValueFromNestedImpl() {
            this.builder = new EnvVarSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EnvVarFluentImpl.this.withValueFrom(this.builder.build());
        }

        @Override
        public N endValueFrom() {
            return this.and();
        }
    }
}

