/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIResourceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIResourceFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIResourceList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIResourceListFluent;

public class APIResourceListFluentImpl<A extends APIResourceListFluent<A>>
extends BaseFluent<A>
implements APIResourceListFluent<A> {
    private String apiVersion;
    private String groupVersion;
    private String kind;
    private ArrayList<APIResourceBuilder> resources = new ArrayList();
    private Map<String, Object> additionalProperties;

    public APIResourceListFluentImpl() {
    }

    public APIResourceListFluentImpl(APIResourceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroupVersion(instance.getGroupVersion());
        this.withKind(instance.getKind());
        this.withResources(instance.getResources());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getGroupVersion() {
        return this.groupVersion;
    }

    @Override
    public A withGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return (A)this;
    }

    @Override
    public Boolean hasGroupVersion() {
        return this.groupVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A addToResources(Integer index, APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        APIResourceBuilder builder = new APIResourceBuilder(item);
        this._visitables.get("resources").add(index >= 0 ? index.intValue() : this._visitables.get("resources").size(), builder);
        this.resources.add(index >= 0 ? index.intValue() : this.resources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResources(Integer index, APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        APIResourceBuilder builder = new APIResourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("resources").size()) {
            this._visitables.get("resources").add(builder);
        } else {
            this._visitables.get("resources").set(index, builder);
        }
        if (index < 0 || index >= this.resources.size()) {
            this.resources.add(builder);
        } else {
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResources(APIResource ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (APIResource item : items) {
            APIResourceBuilder builder = new APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<APIResource> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (APIResource item : items) {
            APIResourceBuilder builder = new APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(APIResource ... items) {
        for (APIResource item : items) {
            APIResourceBuilder builder = new APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<APIResource> items) {
        for (APIResource item : items) {
            APIResourceBuilder builder = new APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResources(Predicate<APIResourceBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<APIResourceBuilder> each = this.resources.iterator();
        Object visitables = this._visitables.get("resources");
        while (each.hasNext()) {
            APIResourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<APIResource> getResources() {
        return this.resources != null ? APIResourceListFluentImpl.build(this.resources) : null;
    }

    @Override
    public List<APIResource> buildResources() {
        return this.resources != null ? APIResourceListFluentImpl.build(this.resources) : null;
    }

    @Override
    public APIResource buildResource(Integer index) {
        return this.resources.get(index).build();
    }

    @Override
    public APIResource buildFirstResource() {
        return this.resources.get(0).build();
    }

    @Override
    public APIResource buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    @Override
    public APIResource buildMatchingResource(Predicate<APIResourceBuilder> predicate) {
        for (APIResourceBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<APIResourceBuilder> predicate) {
        for (APIResourceBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<APIResource> resources) {
        if (this.resources != null) {
            this._visitables.get("resources").removeAll(this.resources);
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (APIResource item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(APIResource ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (APIResource item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public APIResourceListFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    @Override
    public APIResourceListFluent.ResourcesNested<A> addNewResourceLike(APIResource item) {
        return new ResourcesNestedImpl(-1, item);
    }

    @Override
    public APIResourceListFluent.ResourcesNested<A> setNewResourceLike(Integer index, APIResource item) {
        return new ResourcesNestedImpl(index, item);
    }

    @Override
    public APIResourceListFluent.ResourcesNested<A> editResource(Integer index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public APIResourceListFluent.ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public APIResourceListFluent.ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public APIResourceListFluent.ResourcesNested<A> editMatchingResource(Predicate<APIResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIResourceListFluentImpl that = (APIResourceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groupVersion != null ? !this.groupVersion.equals(that.groupVersion) : that.groupVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupVersion, this.kind, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groupVersion != null) {
            sb.append("groupVersion:");
            sb.append(this.groupVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResourcesNestedImpl<N>
    extends APIResourceFluentImpl<APIResourceListFluent.ResourcesNested<N>>
    implements APIResourceListFluent.ResourcesNested<N>,
    Nested<N> {
        APIResourceBuilder builder;
        Integer index;

        ResourcesNestedImpl(Integer index, APIResource item) {
            this.index = index;
            this.builder = new APIResourceBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new APIResourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIResourceListFluentImpl.this.setToResources(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }
}

