/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.BasicBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpHeaders;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpResponse;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.Interceptor;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;

public class TokenRefreshInterceptor
implements Interceptor {
    public static final String NAME = "TOKEN";
    private final Config config;
    private HttpClient.Factory factory;
    private Instant lastRefresh;

    public TokenRefreshInterceptor(Config config, HttpClient.Factory factory) {
        this.config = config;
        this.lastRefresh = Instant.now();
        this.factory = factory;
    }

    @Override
    public void before(BasicBuilder headerBuilder, HttpHeaders headers) {
        if (this.timeToRefresh()) {
            this.refreshToken(headerBuilder);
        }
    }

    @Override
    public boolean afterFailure(BasicBuilder headerBuilder, HttpResponse<?> response) {
        if (response.code() == 401) {
            return this.refreshToken(headerBuilder);
        }
        return false;
    }

    private boolean refreshToken(BasicBuilder headerBuilder) {
        Config newestConfig;
        String newAccessToken;
        boolean resubmit = false;
        String currentContextName = null;
        if (this.config.getCurrentContext() != null) {
            currentContextName = this.config.getCurrentContext().getName();
        }
        if (Utils.isNotNullOrEmpty(newAccessToken = (newestConfig = Config.autoConfigure(currentContextName)).getAuthProvider() != null && newestConfig.getAuthProvider().getName().equalsIgnoreCase("oidc") ? OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(newestConfig.getAuthProvider().getConfig(), this.factory.newBuilder()) : newestConfig.getOauthToken())) {
            headerBuilder.setHeader("Authorization", "Bearer " + newAccessToken);
            this.config.setOauthToken(newAccessToken);
            resubmit = true;
        }
        return resubmit;
    }

    private boolean timeToRefresh() {
        return this.lastRefresh.plus(1L, ChronoUnit.MINUTES).isBefore(Instant.now());
    }

    void setLastRefresh(Instant lastRefresh) {
        this.lastRefresh = lastRefresh;
    }
}

