/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.okhttp;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocket;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import org.apache.flink.kubernetes.shaded.okhttp3.HttpUrl;
import org.apache.flink.kubernetes.shaded.okhttp3.OkHttpClient;
import org.apache.flink.kubernetes.shaded.okhttp3.Request;
import org.apache.flink.kubernetes.shaded.okhttp3.Response;
import org.apache.flink.kubernetes.shaded.okhttp3.WebSocket;
import org.apache.flink.kubernetes.shaded.okhttp3.WebSocketListener;
import org.apache.flink.kubernetes.shaded.okio.ByteString;

class OkHttpWebSocketImpl
implements org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocket {
    private WebSocket webSocket;

    public OkHttpWebSocketImpl(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public boolean send(ByteBuffer buffer) {
        return this.webSocket.send(ByteString.of(buffer));
    }

    @Override
    public boolean sendClose(int code, String reason) {
        return this.webSocket.close(code, reason);
    }

    @Override
    public long queueSize() {
        return this.webSocket.queueSize();
    }

    static class BuilderImpl
    implements WebSocket.Builder {
        private Request.Builder builder = new Request.Builder();
        private OkHttpClient httpClient;

        public BuilderImpl(OkHttpClient httpClient) {
            this.httpClient = httpClient;
        }

        @Override
        public WebSocket.Builder uri(URI uri) {
            this.builder.url(HttpUrl.get(uri));
            return this;
        }

        @Override
        public CompletableFuture<org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocket> buildAsync(final WebSocket.Listener listener) {
            Request request = this.builder.build();
            final CompletableFuture<org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocket> future = new CompletableFuture<org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocket>();
            this.httpClient.newWebSocket(request, new WebSocketListener(){
                private volatile boolean opened;

                @Override
                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    if (response != null) {
                        response.close();
                    }
                    if (!this.opened) {
                        if (response != null) {
                            try {
                                future.completeExceptionally(new WebSocketHandshakeException(new OkHttpClientImpl.OkHttpResponseImpl(response, null)).initCause(t));
                            }
                            catch (IOException iOException) {}
                        } else {
                            future.completeExceptionally(t);
                        }
                    } else {
                        listener.onError(new OkHttpWebSocketImpl(webSocket), t);
                    }
                }

                @Override
                public void onOpen(WebSocket webSocket, Response response) {
                    this.opened = true;
                    if (response != null) {
                        response.close();
                    }
                    OkHttpWebSocketImpl value = new OkHttpWebSocketImpl(webSocket);
                    listener.onOpen(value);
                    future.complete(value);
                }

                @Override
                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    listener.onMessage((org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket), bytes.asByteBuffer());
                }

                @Override
                public void onMessage(WebSocket webSocket, String text) {
                    listener.onMessage((org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket), text);
                }

                @Override
                public void onClosing(WebSocket webSocket, int code, String reason) {
                    listener.onClose(new OkHttpWebSocketImpl(webSocket), code, reason);
                }
            });
            return future;
        }

        @Override
        public WebSocket.Builder header(String name, String value) {
            this.builder = this.builder.addHeader(name, value);
            return this;
        }

        @Override
        public WebSocket.Builder setHeader(String k, String v) {
            this.builder = this.builder.header(k, v);
            return this;
        }
    }
}

