/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.BasicBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpHeaders;

public interface HttpRequest
extends HttpHeaders {
    public static String formURLEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public URI uri();

    public String method();

    public String bodyString();

    public static interface Builder
    extends BasicBuilder {
        public HttpRequest build();

        public Builder uri(String var1);

        public Builder url(URL var1);

        @Override
        public Builder uri(URI var1);

        default public Builder put(String contentType, String writeValueAsString) {
            return this.method("PUT", contentType, writeValueAsString);
        }

        default public Builder post(String contentType, String writeValueAsString) {
            return this.method("POST", contentType, writeValueAsString);
        }

        public Builder post(String var1, byte[] var2);

        public Builder post(String var1, InputStream var2, long var3);

        default public Builder delete(String contentType, String writeValueAsString) {
            return this.method("DELETE", contentType, writeValueAsString);
        }

        default public Builder patch(String contentType, String patchForUpdate) {
            return this.method("PATCH", contentType, patchForUpdate);
        }

        public Builder method(String var1, String var2, String var3);

        @Override
        public Builder header(String var1, String var2);

        @Override
        public Builder setHeader(String var1, String var2);

        default public Builder post(Map<String, String> formData) {
            return this.post("application/x-www-form-urlencoded", formData.entrySet().stream().map(e -> HttpRequest.formURLEncode((String)e.getKey()) + "=" + HttpRequest.formURLEncode((String)e.getValue())).collect(Collectors.joining("&")));
        }

        public Builder expectContinue();
    }
}

