/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.Rule;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleFluentImpl;

public class RuleBuilder
extends RuleFluentImpl<RuleBuilder>
implements VisitableBuilder<Rule, RuleBuilder> {
    RuleFluent<?> fluent;
    Boolean validationEnabled;

    public RuleBuilder() {
        this(false);
    }

    public RuleBuilder(Boolean validationEnabled) {
        this(new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RuleBuilder(RuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance) {
        this(fluent, instance, false);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withApiVersions(instance.getApiVersions());
        fluent.withResources(instance.getResources());
        fluent.withScope(instance.getScope());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public RuleBuilder(Rule instance) {
        this(instance, (Boolean)false);
    }

    public RuleBuilder(Rule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withApiVersions(instance.getApiVersions());
        this.withResources(instance.getResources());
        this.withScope(instance.getScope());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Rule build() {
        Rule buildable = new Rule(this.fluent.getApiGroups(), this.fluent.getApiVersions(), this.fluent.getResources(), this.fluent.getScope());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleBuilder that = (RuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

