/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceFluentImpl;

public class ServiceBuilder
extends ServiceFluentImpl<ServiceBuilder>
implements VisitableBuilder<Service, ServiceBuilder> {
    ServiceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceBuilder() {
        this(false);
    }

    public ServiceBuilder(Boolean validationEnabled) {
        this(new Service(), validationEnabled);
    }

    public ServiceBuilder(ServiceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Service(), validationEnabled);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Service instance) {
        this(fluent, instance, false);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Service instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBuilder(Service instance) {
        this(instance, (Boolean)false);
    }

    public ServiceBuilder(Service instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Service build() {
        Service buildable = new Service(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBuilder that = (ServiceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

