/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceFieldSelector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluentImpl;

public class ResourceFieldSelectorBuilder
extends ResourceFieldSelectorFluentImpl<ResourceFieldSelectorBuilder>
implements VisitableBuilder<ResourceFieldSelector, ResourceFieldSelectorBuilder> {
    ResourceFieldSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceFieldSelectorBuilder() {
        this(false);
    }

    public ResourceFieldSelectorBuilder(Boolean validationEnabled) {
        this(new ResourceFieldSelector(), validationEnabled);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceFieldSelector(), validationEnabled);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, ResourceFieldSelector instance) {
        this(fluent, instance, false);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, ResourceFieldSelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainerName(instance.getContainerName());
        fluent.withDivisor(instance.getDivisor());
        fluent.withResource(instance.getResource());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance) {
        this(instance, (Boolean)false);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainerName(instance.getContainerName());
        this.withDivisor(instance.getDivisor());
        this.withResource(instance.getResource());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceFieldSelector build() {
        ResourceFieldSelector buildable = new ResourceFieldSelector(this.fluent.getContainerName(), this.fluent.getDivisor(), this.fluent.getResource());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceFieldSelectorBuilder that = (ResourceFieldSelectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

