/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerStatusFluentImpl;

public class ContainerStatusBuilder
extends ContainerStatusFluentImpl<ContainerStatusBuilder>
implements VisitableBuilder<ContainerStatus, ContainerStatusBuilder> {
    ContainerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStatusBuilder() {
        this(false);
    }

    public ContainerStatusBuilder(Boolean validationEnabled) {
        this(new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance) {
        this(fluent, instance, false);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainerID(instance.getContainerID());
        fluent.withImage(instance.getImage());
        fluent.withImageID(instance.getImageID());
        fluent.withLastState(instance.getLastState());
        fluent.withName(instance.getName());
        fluent.withReady(instance.getReady());
        fluent.withRestartCount(instance.getRestartCount());
        fluent.withStarted(instance.getStarted());
        fluent.withState(instance.getState());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStatusBuilder(ContainerStatus instance) {
        this(instance, (Boolean)false);
    }

    public ContainerStatusBuilder(ContainerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainerID(instance.getContainerID());
        this.withImage(instance.getImage());
        this.withImageID(instance.getImageID());
        this.withLastState(instance.getLastState());
        this.withName(instance.getName());
        this.withReady(instance.getReady());
        this.withRestartCount(instance.getRestartCount());
        this.withStarted(instance.getStarted());
        this.withState(instance.getState());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerStatus build() {
        ContainerStatus buildable = new ContainerStatus(this.fluent.getContainerID(), this.fluent.getImage(), this.fluent.getImageID(), this.fluent.getLastState(), this.fluent.getName(), this.fluent.getReady(), this.fluent.getRestartCount(), this.fluent.getStarted(), this.fluent.getState());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStatusBuilder that = (ContainerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

