/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Affinity;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.AffinityFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.AffinityFluentImpl;

public class AffinityBuilder
extends AffinityFluentImpl<AffinityBuilder>
implements VisitableBuilder<Affinity, AffinityBuilder> {
    AffinityFluent<?> fluent;
    Boolean validationEnabled;

    public AffinityBuilder() {
        this(false);
    }

    public AffinityBuilder(Boolean validationEnabled) {
        this(new Affinity(), validationEnabled);
    }

    public AffinityBuilder(AffinityFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Affinity(), validationEnabled);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance) {
        this(fluent, instance, false);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNodeAffinity(instance.getNodeAffinity());
        fluent.withPodAffinity(instance.getPodAffinity());
        fluent.withPodAntiAffinity(instance.getPodAntiAffinity());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public AffinityBuilder(Affinity instance) {
        this(instance, (Boolean)false);
    }

    public AffinityBuilder(Affinity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNodeAffinity(instance.getNodeAffinity());
        this.withPodAffinity(instance.getPodAffinity());
        this.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Affinity build() {
        Affinity buildable = new Affinity(this.fluent.getNodeAffinity(), this.fluent.getPodAffinity(), this.fluent.getPodAntiAffinity());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AffinityBuilder that = (AffinityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

