/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.factory;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.CmdTaskManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.EnvSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.FlinkConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.HadoopConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.InitTaskManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KerberosMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.MountSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesTaskManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesPod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.util.Preconditions;

public class KubernetesTaskManagerFactory {
    public static KubernetesPod buildTaskManagerKubernetesPod(FlinkPod podTemplate, KubernetesTaskManagerParameters kubernetesTaskManagerParameters) {
        FlinkPod flinkPod = ((FlinkPod)Preconditions.checkNotNull((Object)podTemplate)).copy();
        ArrayList<AbstractKubernetesStepDecorator> stepDecorators = new ArrayList<AbstractKubernetesStepDecorator>(Arrays.asList(new InitTaskManagerDecorator(kubernetesTaskManagerParameters), new EnvSecretsDecorator(kubernetesTaskManagerParameters), new MountSecretsDecorator(kubernetesTaskManagerParameters), new CmdTaskManagerDecorator(kubernetesTaskManagerParameters)));
        Configuration configuration = kubernetesTaskManagerParameters.getFlinkConfiguration();
        if (configuration.getBoolean(KubernetesConfigOptions.KUBERNETES_HADOOP_CONF_MOUNT_DECORATOR_ENABLED)) {
            stepDecorators.add(new HadoopConfMountDecorator(kubernetesTaskManagerParameters));
        }
        if (configuration.getBoolean(KubernetesConfigOptions.KUBERNETES_KERBEROS_MOUNT_DECORATOR_ENABLED)) {
            stepDecorators.add(new KerberosMountDecorator(kubernetesTaskManagerParameters));
        }
        stepDecorators.add(new FlinkConfMountDecorator(kubernetesTaskManagerParameters));
        for (KubernetesStepDecorator kubernetesStepDecorator : stepDecorators) {
            flinkPod = kubernetesStepDecorator.decorateFlinkPod(flinkPod);
        }
        Pod resolvedPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(flinkPod.getPodWithoutMainContainer()).editOrNewSpec().addToContainers(flinkPod.getMainContainer())).endSpec()).build();
        return new KubernetesPod(resolvedPod);
    }
}

