/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.services;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.Endpoint;
import org.apache.flink.kubernetes.kubeclient.decorators.ExternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;

public abstract class ServiceType {
    public Service buildUpExternalRestService(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        String serviceName = ExternalServiceDecorator.getExternalServiceName(kubernetesJobManagerParameters.getClusterId());
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceBuilder)new ServiceBuilder().withApiVersion("v1")).withNewMetadata().withName(serviceName)).withLabels(kubernetesJobManagerParameters.getCommonLabels())).withAnnotations(kubernetesJobManagerParameters.getRestServiceAnnotations())).endMetadata()).withNewSpec().withType(kubernetesJobManagerParameters.getRestServiceExposedType().serviceType().getType())).withSelector(kubernetesJobManagerParameters.getSelectors())).addNewPort().withName("rest")).withPort(kubernetesJobManagerParameters.getRestPort())).withNewTargetPort(kubernetesJobManagerParameters.getRestBindPort())).endPort()).endSpec()).build();
    }

    public abstract Service buildUpInternalService(KubernetesJobManagerParameters var1);

    public abstract Optional<Endpoint> getRestEndpoint(Service var1, NamespacedKubernetesClient var2, KubernetesConfigOptions.NodePortAddressType var3);

    public abstract int getRestPort(ServicePort var1);

    public abstract String getType();

    public int getRestPortFromExternalService(Service externalService) {
        List servicePortCandidates = externalService.getSpec().getPorts().stream().filter(x -> x.getName().equals("rest")).collect(Collectors.toList());
        if (servicePortCandidates.isEmpty()) {
            throw new RuntimeException("Failed to find port \"rest\" in Service \"" + externalService.getMetadata().getName() + "\"");
        }
        ServicePort externalServicePort = (ServicePort)servicePortCandidates.get(0);
        return this.getRestPort(externalServicePort);
    }

    public static KubernetesConfigOptions.ServiceExposedType classify(Service service) {
        KubernetesConfigOptions.ServiceExposedType type = KubernetesConfigOptions.ServiceExposedType.valueOf(service.getSpec().getType());
        if (type == KubernetesConfigOptions.ServiceExposedType.ClusterIP && "None".equals(service.getSpec().getClusterIP())) {
            type = KubernetesConfigOptions.ServiceExposedType.Headless_ClusterIP;
        }
        return type;
    }
}

