/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.services;

import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import java.util.Optional;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.Endpoint;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.services.ServiceType;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePortService
extends ServiceType {
    private static final Logger LOG = LoggerFactory.getLogger(NodePortService.class);
    public static final NodePortService INSTANCE = new NodePortService();

    private NodePortService() {
    }

    @Override
    public Service buildUpInternalService(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<Endpoint> getRestEndpoint(Service targetService, NamespacedKubernetesClient internalClient, KubernetesConfigOptions.NodePortAddressType nodePortAddressType) {
        if (targetService.getStatus() == null) {
            return Optional.empty();
        }
        String address = ((NodeList)internalClient.nodes().list()).getItems().stream().filter(node -> node.getSpec().getUnschedulable() == null || node.getSpec().getUnschedulable() == false).flatMap(node -> node.getStatus().getAddresses().stream()).filter(nodeAddress -> nodePortAddressType.name().equals(nodeAddress.getType())).map(NodeAddress::getAddress).filter(ip -> !ip.isEmpty()).findAny().orElse(null);
        if (address == null) {
            LOG.warn("Unable to find any node ip with type [{}]. Please see [{}] config option for more details.", (Object)nodePortAddressType, (Object)KubernetesConfigOptions.REST_SERVICE_EXPOSED_NODE_PORT_ADDRESS_TYPE.key());
        }
        return StringUtils.isNullOrWhitespaceOnly((String)address) ? Optional.empty() : Optional.of(new Endpoint(address, this.getRestPortFromExternalService(targetService)));
    }

    @Override
    public int getRestPort(ServicePort port) {
        return port.getNodePort();
    }

    @Override
    public String getType() {
        return KubernetesConfigOptions.ServiceExposedType.NodePort.name();
    }
}

