/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.kubernetes.highavailability.KubernetesLeaderRetrievalDriver;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.KubernetesConfigMapSharedWatcher;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.Preconditions;

public class KubernetesMultipleComponentLeaderRetrievalDriverFactory
implements LeaderRetrievalDriverFactory {
    private final FlinkKubeClient kubeClient;
    private final KubernetesConfigMapSharedWatcher configMapSharedWatcher;
    private final Executor watchExecutor;
    private final String configMapName;
    private final String componentId;

    public KubernetesMultipleComponentLeaderRetrievalDriverFactory(FlinkKubeClient kubeClient, KubernetesConfigMapSharedWatcher configMapSharedWatcher, Executor watchExecutor, String configMapName, String componentId) {
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient);
        this.configMapSharedWatcher = (KubernetesConfigMapSharedWatcher)Preconditions.checkNotNull((Object)configMapSharedWatcher);
        this.watchExecutor = (Executor)Preconditions.checkNotNull((Object)watchExecutor);
        this.configMapName = (String)Preconditions.checkNotNull((Object)configMapName);
        this.componentId = (String)Preconditions.checkNotNull((Object)componentId);
    }

    public LeaderRetrievalDriver createLeaderRetrievalDriver(LeaderRetrievalEventHandler leaderEventHandler, FatalErrorHandler fatalErrorHandler) {
        return new KubernetesLeaderRetrievalDriver(this.configMapSharedWatcher, this.watchExecutor, this.configMapName, leaderEventHandler, this::extractLeaderInformation, fatalErrorHandler);
    }

    public LeaderInformation extractLeaderInformation(KubernetesConfigMap configMap) {
        String configDataLeaderKey = KubernetesUtils.createSingleLeaderKey(this.componentId);
        Map<String, String> data = configMap.getData();
        if (data.containsKey(configDataLeaderKey)) {
            return KubernetesUtils.parseLeaderInformationSafely(data.get(configDataLeaderKey)).orElse(LeaderInformation.empty());
        }
        return LeaderInformation.empty();
    }
}

