/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import java.util.Map;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesOwnerReference
extends KubernetesResource<OwnerReference> {
    private static final String API_VERSION = "apiversion";
    private static final String DELETION = "blockownerdeletion";
    private static final String CONTROLLER = "controller";
    private static final String KIND = "kind";
    private static final String NAME = "name";
    private static final String UUID = "uid";
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesOwnerReference.class);

    private KubernetesOwnerReference(OwnerReference ownerReference) {
        super(ownerReference);
    }

    public static KubernetesOwnerReference fromMap(Map<String, String> stringMap) {
        OwnerReferenceBuilder ownerReferenceBuilder = new OwnerReferenceBuilder();
        stringMap.forEach((k, v) -> {
            switch (k.toLowerCase()) {
                case "apiversion": {
                    ownerReferenceBuilder.withApiVersion((String)v);
                    break;
                }
                case "blockownerdeletion": {
                    ownerReferenceBuilder.withBlockOwnerDeletion(Boolean.valueOf(v));
                    break;
                }
                case "controller": {
                    ownerReferenceBuilder.withController(Boolean.valueOf(v));
                    break;
                }
                case "kind": {
                    ownerReferenceBuilder.withKind((String)v);
                    break;
                }
                case "name": {
                    ownerReferenceBuilder.withName((String)v);
                    break;
                }
                case "uid": {
                    ownerReferenceBuilder.withUid((String)v);
                    break;
                }
                default: {
                    LOG.warn("Unrecognized key({}) of toleration, will ignore.", k);
                }
            }
        });
        return new KubernetesOwnerReference(ownerReferenceBuilder.build());
    }
}

