/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.serialization;

import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.PropertyName;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.NullValueProvider;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.exc.MismatchedInputException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;

public class SettableBeanPropertyDelegate
extends SettableBeanProperty {
    private final SettableBeanProperty delegate;
    private final SettableAnyProperty anySetter;
    private final transient Supplier<Boolean> restrictToTemplates;

    SettableBeanPropertyDelegate(SettableBeanProperty delegate, SettableAnyProperty anySetter, Supplier<Boolean> restrictToTemplates) {
        super(delegate);
        this.delegate = delegate;
        this.anySetter = anySetter;
        this.restrictToTemplates = restrictToTemplates;
    }

    @Override
    public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new SettableBeanPropertyDelegate(this.delegate.withValueDeserializer(deser), this.anySetter, this.restrictToTemplates);
    }

    @Override
    public SettableBeanProperty withName(PropertyName newName) {
        return new SettableBeanPropertyDelegate(this.delegate.withName(newName), this.anySetter, this.restrictToTemplates);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nva) {
        return new SettableBeanPropertyDelegate(this.delegate.withNullProvider(nva), this.anySetter, this.restrictToTemplates);
    }

    @Override
    public AnnotatedMember getMember() {
        return this.delegate.getMember();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this.delegate.getAnnotation(acls);
    }

    @Override
    public void fixAccess(DeserializationConfig config) {
        this.delegate.fixAccess(config);
    }

    @Override
    public void markAsIgnorable() {
        this.delegate.markAsIgnorable();
    }

    @Override
    public boolean isIgnorable() {
        return this.delegate.isIgnorable();
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        try {
            this.delegate.deserializeAndSet(p, ctxt, instance);
        }
        catch (MismatchedInputException ex) {
            if (this.shouldUseAnySetter()) {
                this.anySetter.set(instance, this.delegate.getName(), p.getText());
            }
            throw ex;
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        try {
            return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
        }
        catch (MismatchedInputException ex) {
            this.deserializeAndSet(p, ctxt, instance);
            return null;
        }
    }

    @Override
    public void set(Object instance, Object value) throws IOException {
        this.delegate.set(instance, value);
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this.delegate.setAndReturn(instance, value);
    }

    private boolean shouldUseAnySetter() {
        if (this.anySetter == null) {
            return false;
        }
        if (Boolean.TRUE.equals(this.restrictToTemplates.get())) {
            return KubernetesDeserializer.isInTemplate();
        }
        return true;
    }
}

