/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Toleration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesTaskManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesToleration;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class InitTaskManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesTaskManagerParameters kubernetesTaskManagerParameters;
    private final Configuration flinkConfig;

    public InitTaskManagerDecorator(KubernetesTaskManagerParameters kubernetesTaskManagerParameters) {
        this.kubernetesTaskManagerParameters = (KubernetesTaskManagerParameters)Preconditions.checkNotNull((Object)kubernetesTaskManagerParameters);
        this.flinkConfig = (Configuration)Preconditions.checkNotNull((Object)kubernetesTaskManagerParameters.getFlinkConfiguration());
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        PodBuilder basicPodBuilder = new PodBuilder(flinkPod.getPodWithoutMainContainer());
        String serviceAccountName = KubernetesUtils.resolveUserDefinedValue(this.flinkConfig, KubernetesConfigOptions.TASK_MANAGER_SERVICE_ACCOUNT, this.kubernetesTaskManagerParameters.getServiceAccount(), KubernetesUtils.getServiceAccount(flinkPod), "service account");
        String dnsPolicy = KubernetesUtils.resolveDNSPolicy(flinkPod.getPodWithoutMainContainer().getSpec().getDnsPolicy(), this.kubernetesTaskManagerParameters.isHostNetworkEnabled());
        if (flinkPod.getPodWithoutMainContainer().getSpec().getRestartPolicy() != null) {
            this.logger.info("The restart policy of TaskManager pod will be overwritten to 'never' since it should not be restarted.");
        }
        ((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodBuilder)basicPodBuilder.withApiVersion("v1")).editOrNewMetadata().withName(this.kubernetesTaskManagerParameters.getPodName())).endMetadata()).editOrNewSpec().withServiceAccount(serviceAccountName)).withServiceAccountName(serviceAccountName)).withRestartPolicy("Never")).withHostNetwork(this.kubernetesTaskManagerParameters.isHostNetworkEnabled())).withDnsPolicy(dnsPolicy)).endSpec();
        ((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)basicPodBuilder.editOrNewMetadata().addToLabels(this.kubernetesTaskManagerParameters.getLabels())).addToAnnotations(this.kubernetesTaskManagerParameters.getAnnotations())).endMetadata()).editOrNewSpec().addToImagePullSecrets(this.kubernetesTaskManagerParameters.getImagePullSecrets())).addToNodeSelector(this.kubernetesTaskManagerParameters.getNodeSelector())).addAllToTolerations(this.kubernetesTaskManagerParameters.getTolerations().stream().map(e -> (Toleration)KubernetesToleration.fromMap(e).getInternalResource()).collect(Collectors.toList()))).endSpec();
        Container basicMainContainer = this.decorateMainContainer(flinkPod.getMainContainer());
        return new FlinkPod.Builder(flinkPod).withPod(basicPodBuilder.build()).withMainContainer(basicMainContainer).build();
    }

    private Container decorateMainContainer(Container container) {
        ContainerBuilder mainContainerBuilder = new ContainerBuilder(container);
        ResourceRequirements requirementsInPodTemplate = container.getResources() == null ? new ResourceRequirements() : container.getResources();
        ResourceRequirements resourceRequirements = KubernetesUtils.getResourceRequirements(requirementsInPodTemplate, this.kubernetesTaskManagerParameters.getTaskManagerMemoryMB(), this.kubernetesTaskManagerParameters.getTaskManagerMemoryLimitFactor(), this.kubernetesTaskManagerParameters.getTaskManagerCPU(), this.kubernetesTaskManagerParameters.getTaskManagerCPULimitFactor(), this.kubernetesTaskManagerParameters.getTaskManagerExternalResources(), this.kubernetesTaskManagerParameters.getTaskManagerExternalResourceConfigKeys());
        String image = KubernetesUtils.resolveUserDefinedValue(this.flinkConfig, KubernetesConfigOptions.CONTAINER_IMAGE, this.kubernetesTaskManagerParameters.getImage(), container.getImage(), "main container image");
        String imagePullPolicy = KubernetesUtils.resolveUserDefinedValue(this.flinkConfig, KubernetesConfigOptions.CONTAINER_IMAGE_PULL_POLICY, this.kubernetesTaskManagerParameters.getImagePullPolicy().name(), container.getImagePullPolicy(), "main container image pull policy");
        ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)mainContainerBuilder.withName("flink-main-container")).withImage(image)).withImagePullPolicy(imagePullPolicy)).withResources(resourceRequirements);
        ((ContainerBuilder)mainContainerBuilder.addAllToPorts(this.getContainerPorts())).addAllToEnv(this.getCustomizedEnvs());
        this.getFlinkLogDirEnv().ifPresent(xva$0 -> mainContainerBuilder.addToEnv((EnvVar)xva$0));
        return mainContainerBuilder.build();
    }

    private List<ContainerPort> getContainerPorts() {
        if (this.kubernetesTaskManagerParameters.isHostNetworkEnabled()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("taskmanager-rpc")).withContainerPort(this.kubernetesTaskManagerParameters.getRPCPort())).build());
    }

    private List<EnvVar> getCustomizedEnvs() {
        return this.kubernetesTaskManagerParameters.getEnvironments().entrySet().stream().map(kv -> new EnvVar((String)kv.getKey(), (String)kv.getValue(), null)).collect(Collectors.toList());
    }

    private Optional<EnvVar> getFlinkLogDirEnv() {
        return this.kubernetesTaskManagerParameters.getFlinkLogDirInPod().map(logDir -> new EnvVar("FLINK_LOG_DIR", (String)logDir, null));
    }
}

