/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.parameters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.util.Preconditions;

public class KubernetesTaskManagerParameters
extends AbstractKubernetesParameters {
    private final String podName;
    private final String dynamicProperties;
    private final String jvmMemOptsEnv;
    private final ContaineredTaskManagerParameters containeredTaskManagerParameters;
    private final Map<String, String> taskManagerExternalResourceConfigKeys;

    public KubernetesTaskManagerParameters(Configuration flinkConfig, String podName, String dynamicProperties, String jvmMemOptsEnv, ContaineredTaskManagerParameters containeredTaskManagerParameters, Map<String, String> taskManagerExternalResourceConfigKeys) {
        super(flinkConfig);
        this.podName = (String)Preconditions.checkNotNull((Object)podName);
        this.dynamicProperties = (String)Preconditions.checkNotNull((Object)dynamicProperties);
        this.jvmMemOptsEnv = (String)Preconditions.checkNotNull((Object)jvmMemOptsEnv);
        this.containeredTaskManagerParameters = (ContaineredTaskManagerParameters)Preconditions.checkNotNull((Object)containeredTaskManagerParameters);
        this.taskManagerExternalResourceConfigKeys = (Map)Preconditions.checkNotNull(taskManagerExternalResourceConfigKeys);
    }

    @Override
    public Map<String, String> getLabels() {
        HashMap labels = new HashMap();
        labels.putAll(this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_LABELS).orElse(Collections.emptyMap()));
        labels.putAll(this.getSelectors());
        return Collections.unmodifiableMap(labels);
    }

    @Override
    public Map<String, String> getSelectors() {
        return KubernetesUtils.getTaskManagerSelectors(this.getClusterId());
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return Collections.unmodifiableMap(this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_NODE_SELECTOR).orElse(Collections.emptyMap()));
    }

    @Override
    public Map<String, String> getEnvironments() {
        return this.containeredTaskManagerParameters.taskManagerEnv();
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_ANNOTATIONS).orElse(Collections.emptyMap());
    }

    @Override
    public List<Map<String, String>> getTolerations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_TOLERATIONS).orElse(Collections.emptyList());
    }

    public String getPodName() {
        return this.podName;
    }

    public int getTaskManagerMemoryMB() {
        return this.containeredTaskManagerParameters.getTaskExecutorProcessSpec().getTotalProcessMemorySize().getMebiBytes();
    }

    public double getTaskManagerCPU() {
        return this.containeredTaskManagerParameters.getTaskExecutorProcessSpec().getCpuCores().getValue().doubleValue();
    }

    public double getTaskManagerCPULimitFactor() {
        double limitFactor = this.flinkConfig.getDouble(KubernetesConfigOptions.TASK_MANAGER_CPU_LIMIT_FACTOR);
        Preconditions.checkArgument((limitFactor >= 1.0 ? 1 : 0) != 0, (String)"%s should be greater or equal to 1.", (Object[])new Object[]{KubernetesConfigOptions.TASK_MANAGER_CPU_LIMIT_FACTOR.key()});
        return limitFactor;
    }

    public double getTaskManagerMemoryLimitFactor() {
        double limitFactor = this.flinkConfig.getDouble(KubernetesConfigOptions.TASK_MANAGER_MEMORY_LIMIT_FACTOR);
        Preconditions.checkArgument((limitFactor >= 1.0 ? 1 : 0) != 0, (String)"%s should be greater or equal to 1.", (Object[])new Object[]{KubernetesConfigOptions.TASK_MANAGER_MEMORY_LIMIT_FACTOR.key()});
        return limitFactor;
    }

    public Map<String, ExternalResource> getTaskManagerExternalResources() {
        return this.containeredTaskManagerParameters.getTaskExecutorProcessSpec().getExtendedResources();
    }

    public String getServiceAccount() {
        return (String)this.flinkConfig.get(KubernetesConfigOptions.TASK_MANAGER_SERVICE_ACCOUNT);
    }

    public Map<String, String> getTaskManagerExternalResourceConfigKeys() {
        return Collections.unmodifiableMap(this.taskManagerExternalResourceConfigKeys);
    }

    public int getRPCPort() {
        int taskManagerRpcPort = KubernetesUtils.parsePort(this.flinkConfig, (ConfigOption<String>)TaskManagerOptions.RPC_PORT);
        Preconditions.checkArgument((taskManagerRpcPort > 0 ? 1 : 0) != 0, (String)"%s should not be 0.", (Object[])new Object[]{TaskManagerOptions.RPC_PORT.key()});
        return taskManagerRpcPort;
    }

    public String getDynamicProperties() {
        return this.dynamicProperties;
    }

    public String getJvmMemOptsEnv() {
        return this.jvmMemOptsEnv;
    }

    public ContaineredTaskManagerParameters getContaineredTaskManagerParameters() {
        return this.containeredTaskManagerParameters;
    }
}

