/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.kubernetes.highavailability.KubernetesHaServices;
import org.apache.flink.kubernetes.highavailability.KubernetesMultipleComponentLeaderElectionHaServices;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClientFactory;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesFactory;
import org.apache.flink.util.FatalExitExceptionHandler;

public class KubernetesHaServicesFactory
implements HighAvailabilityServicesFactory {
    public HighAvailabilityServices createHAServices(Configuration configuration, Executor executor) throws Exception {
        boolean useOldHaServices = (Boolean)configuration.get(HighAvailabilityOptions.USE_OLD_HA_SERVICES);
        if (useOldHaServices) {
            return new KubernetesHaServices(FlinkKubeClientFactory.getInstance().fromConfiguration(configuration, "kubernetes-ha-services"), executor, configuration, BlobUtils.createBlobStoreFromConfig((Configuration)configuration));
        }
        return new KubernetesMultipleComponentLeaderElectionHaServices(FlinkKubeClientFactory.getInstance().fromConfiguration(configuration, "kubernetes-ha-services"), executor, configuration, BlobUtils.createBlobStoreFromConfig((Configuration)configuration), error -> FatalExitExceptionHandler.INSTANCE.uncaughtException(Thread.currentThread(), error));
    }
}

